/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.FitNesseContext;
import fitnesse.VelocityFactory;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlUtil;
import fitnesse.html.SetupTeardownAndLibraryIncluder;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.NotFoundResponder;
import fitnesse.responders.WikiImportProperty;
import fitnesse.responders.editing.EditResponder;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VirtualEnabledPageCrawler;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import org.apache.velocity.VelocityContext;

public class WikiPageResponder
implements SecureResponder {
    protected WikiPage page;
    protected PageData pageData;
    protected String pageTitle;
    protected Request request;
    protected PageCrawler crawler;

    public WikiPageResponder() {
    }

    public WikiPageResponder(WikiPage page) throws Exception {
        this.page = page;
        this.pageData = page.getData();
    }

    @Override
    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        this.loadPage(request.getResource(), context);
        if (this.page == null) {
            return this.notFoundResponse(context, request);
        }
        return this.makePageResponse(context);
    }

    protected void loadPage(String pageName, FitNesseContext context) throws Exception {
        WikiPagePath path = PathParser.parse(pageName);
        this.crawler = context.root.getPageCrawler();
        this.crawler.setDeadEndStrategy(new VirtualEnabledPageCrawler());
        this.page = this.crawler.getPage(context.root, path);
        if (this.page != null) {
            this.pageData = this.page.getData();
        }
    }

    private Response notFoundResponse(FitNesseContext context, Request request) throws Exception {
        if (this.dontCreateNonExistentPage(request)) {
            return new NotFoundResponder().makeResponse(context, request);
        }
        return new EditResponder().makeResponseForNonExistentPage(context, request);
    }

    private boolean dontCreateNonExistentPage(Request request) {
        String dontCreate = (String)request.getInput("dontCreatePage");
        return dontCreate != null && (dontCreate.length() == 0 || Boolean.parseBoolean(dontCreate));
    }

    private SimpleResponse makePageResponse(FitNesseContext context) throws Exception {
        this.pageTitle = PathParser.render(this.crawler.getFullPath(this.page));
        String html = this.makeHtml(context);
        SimpleResponse response = new SimpleResponse();
        response.setMaxAge(0);
        response.setContent(html);
        return response;
    }

    public String makeHtml(FitNesseContext context) throws Exception {
        WikiPage page = this.pageData.getWikiPage();
        HtmlPage html = context.htmlPageFactory.newPage();
        WikiPagePath fullPath = page.getPageCrawler().getFullPath(page);
        String fullPathName = PathParser.render(fullPath);
        html.title.use(fullPathName);
        html.header.use(HtmlUtil.makeBreadCrumbsWithCurrentPageNotLinked(fullPathName));
        html.header.add("<a style=\"font-size:small;\" onclick=\"popup('addChildPopup')\"> [add child]</a>");
        html.actions.use(HtmlUtil.makeActions(page.getActions()));
        SetupTeardownAndLibraryIncluder.includeInto(this.pageData);
        html.main.use(this.generateHtml(this.pageData));
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("page_name", page.getName());
        velocityContext.put("full_path", fullPathName);
        html.main.add(VelocityFactory.translateTemplate(velocityContext, "addChildPagePopup.vm"));
        this.handleSpecialProperties(html, page);
        return html.html();
    }

    protected String generateHtml(PageData pageData) throws Exception {
        return HtmlUtil.makePageHtmlWithHeaderAndFooter(pageData);
    }

    private void handleSpecialProperties(HtmlPage html, WikiPage page) throws Exception {
        WikiImportProperty.handleImportProperties(html, page, this.pageData);
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }
}

