/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fit.FitProtocol;
import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.components.ClassPathBuilder;
import fitnesse.components.FitClient;
import fitnesse.html.SetupTeardownAndLibraryIncluder;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.ResponseSender;
import fitnesse.responders.run.MultipleTestsRunner;
import fitnesse.responders.run.PuppetResponse;
import fitnesse.responders.run.ResponsePuppeteer;
import fitnesse.responders.run.SuiteContentsFinder;
import fitnesse.responders.run.SuiteFilter;
import fitnesse.responders.run.TestSummary;
import fitnesse.responders.run.TestSystemListener;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VirtualEnabledPageCrawler;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.net.Socket;
import java.util.List;

public class FitClientResponder
implements Responder,
ResponsePuppeteer,
TestSystemListener {
    private FitNesseContext context;
    private PageCrawler crawler;
    private String resource;
    private WikiPage page;
    private boolean shouldIncludePaths;
    private String suiteFilter;

    @Override
    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        this.context = context;
        this.crawler = context.root.getPageCrawler();
        this.crawler.setDeadEndStrategy(new VirtualEnabledPageCrawler());
        this.resource = request.getResource();
        this.shouldIncludePaths = request.hasInput("includePaths");
        this.suiteFilter = (String)request.getInput("suiteFilter");
        return new PuppetResponse(this);
    }

    @Override
    public void readyToSend(ResponseSender sender) throws Exception {
        Socket socket = sender.getSocket();
        WikiPagePath pagePath = PathParser.parse(this.resource);
        if (!this.crawler.pageExists(this.context.root, pagePath)) {
            FitProtocol.writeData(this.notFoundMessage(), socket.getOutputStream());
        } else {
            this.page = this.crawler.getPage(this.context.root, pagePath);
            PageData data = this.page.getData();
            if (data.hasAttribute("Suite")) {
                this.handleSuitePage(socket, this.page, this.context.root);
            } else if (data.hasAttribute("Test")) {
                this.handleTestPage(socket, data);
            } else {
                FitProtocol.writeData(this.notATestMessage(), socket.getOutputStream());
            }
        }
        sender.close();
    }

    private void handleTestPage(Socket socket, PageData data) throws Exception {
        FitClient client = this.startClient(socket);
        if (this.shouldIncludePaths) {
            String classpath = new ClassPathBuilder().getClasspath(this.page);
            client.send(classpath);
        }
        this.sendPage(data, client, true);
        this.closeClient(client);
    }

    private void handleSuitePage(Socket socket, WikiPage page, WikiPage root) throws Exception {
        FitClient client = this.startClient(socket);
        SuiteFilter filter = new SuiteFilter(this.suiteFilter, null, null);
        SuiteContentsFinder suiteTestFinder = new SuiteContentsFinder(page, filter, root);
        List<WikiPage> testPages = suiteTestFinder.makePageList();
        if (this.shouldIncludePaths) {
            MultipleTestsRunner runner = new MultipleTestsRunner(testPages, this.context, page, null);
            String classpath = runner.buildClassPath();
            client.send(classpath);
        }
        for (WikiPage testPage : testPages) {
            PageData testPageData = testPage.getData();
            this.sendPage(testPageData, client, false);
        }
        this.closeClient(client);
    }

    private void sendPage(PageData data, FitClient client, boolean includeSuiteSetup) throws Exception {
        String pageName = this.crawler.getRelativeName(this.page, data.getWikiPage());
        SetupTeardownAndLibraryIncluder.includeInto(data, includeSuiteSetup);
        String testableHtml = data.getHtml();
        String sendableHtml = pageName + "\n" + testableHtml;
        client.send(sendableHtml);
    }

    private void closeClient(FitClient client) throws Exception {
        client.done();
        client.join();
    }

    private FitClient startClient(Socket socket) throws Exception {
        FitClient client = new FitClient(this);
        client.acceptSocket(socket);
        return client;
    }

    private String notATestMessage() {
        return this.resource + " is neither a Test page nor a Suite page.";
    }

    private String notFoundMessage() {
        return "The page " + this.resource + " was not found.";
    }

    @Override
    public void acceptOutputFirst(String output) throws Exception {
    }

    @Override
    public void testComplete(TestSummary testSummary) throws Exception {
    }

    @Override
    public void exceptionOccurred(Throwable e) {
    }
}

