/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.FitNesseContext;
import fitnesse.components.CommandRunningFitClient;
import fitnesse.responders.run.ExecutionLog;
import fitnesse.responders.run.TestSystem;
import fitnesse.responders.run.TestSystemListener;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;
import java.util.Map;

public class FitTestSystem
extends TestSystem {
    private CommandRunningFitClient client;
    private FitNesseContext context;

    public FitTestSystem(FitNesseContext context, WikiPage page, TestSystemListener listener) {
        super(page, listener);
        this.context = context;
    }

    @Override
    protected ExecutionLog createExecutionLog(String classPath, TestSystem.Descriptor descriptor) throws Exception {
        String command = this.buildCommand(descriptor, classPath);
        Map<String, String> environmentVariables = this.createClasspathEnvironment(classPath);
        this.client = new CommandRunningFitClient(this, command, this.context.port, environmentVariables, this.context.socketDealer, this.fastTest);
        return new ExecutionLog(this.page, this.client.commandRunner);
    }

    @Override
    public void bye() throws Exception {
        this.client.done();
        this.client.join();
    }

    @Override
    public String runTestsAndGenerateHtml(PageData pageData) throws Exception {
        String html = pageData.getHtml();
        if (html.length() == 0) {
            this.client.send("OH NO! This page is empty!");
        } else {
            this.client.send(html);
        }
        return html;
    }

    @Override
    public boolean isSuccessfullyStarted() {
        return this.client.isSuccessfullyStarted();
    }

    @Override
    public void kill() throws Exception {
        this.client.kill();
    }

    @Override
    public void start() throws Exception {
        this.client.start();
    }
}

