/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run.formatters;

import fitnesse.FitNesseContext;
import fitnesse.responders.run.ResultsListener;
import fitnesse.responders.run.TestSummary;
import fitnesse.responders.run.formatters.NullFormatter;
import fitnesse.wiki.WikiPage;
import util.TimeMeasurement;

public abstract class BaseFormatter
implements ResultsListener {
    protected WikiPage page = null;
    protected FitNesseContext context;
    public static final BaseFormatter NULL = new NullFormatter();
    public static int finalErrorCount = 0;
    protected int testCount = 0;
    protected int failCount = 0;

    public abstract void writeHead(String var1) throws Exception;

    protected BaseFormatter() {
    }

    protected BaseFormatter(FitNesseContext context, WikiPage page) {
        this.page = page;
        this.context = context;
    }

    protected WikiPage getPage() {
        return this.page;
    }

    @Override
    public void errorOccured() {
        try {
            this.allTestingComplete(new TimeMeasurement().start().stop());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void allTestingComplete(TimeMeasurement totalTimeMeasurement) throws Exception {
        finalErrorCount = this.failCount;
    }

    @Override
    public void announceNumberTestsToRun(int testsToRun) {
    }

    @Override
    public void testComplete(WikiPage test, TestSummary summary, TimeMeasurement timeMeasurement) throws Exception {
        ++this.testCount;
        if (summary.wrong > 0) {
            ++this.failCount;
        }
        if (summary.exceptions > 0) {
            ++this.failCount;
        }
    }

    public void addMessageForBlankHtml() throws Exception {
    }

    public int getErrorCount() {
        return 0;
    }
}

