/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run.formatters;

import fitnesse.http.ChunkedResponse;
import fitnesse.responders.run.CompositeExecutionLog;
import fitnesse.responders.run.TestSummary;
import fitnesse.responders.run.TestSystem;
import fitnesse.responders.run.formatters.BaseFormatter;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import java.text.SimpleDateFormat;
import util.TimeMeasurement;

public class TestTextFormatter
extends BaseFormatter {
    private ChunkedResponse response;

    public TestTextFormatter(ChunkedResponse response) {
        this.response = response;
    }

    @Override
    public void writeHead(String pageType) throws Exception {
    }

    @Override
    public void setExecutionLogAndTrackingId(String stopResponderId, CompositeExecutionLog log) throws Exception {
    }

    @Override
    public void testSystemStarted(TestSystem testSystem, String testSystemName, String testRunner) throws Exception {
        this.response.add(String.format("\nStarting Test System: %s using %s.\n", testSystemName, testRunner));
    }

    @Override
    public void newTestStarted(WikiPage page, TimeMeasurement timeMeasurement) throws Exception {
    }

    private String getPath(WikiPage page) throws Exception {
        return PathParser.render(page.getPageCrawler().getFullPath(page));
    }

    @Override
    public void testOutputChunk(String output) throws Exception {
    }

    @Override
    public void testComplete(WikiPage page, TestSummary summary, TimeMeasurement timeMeasurement) throws Exception {
        super.testComplete(page, summary, timeMeasurement);
        String timeString = new SimpleDateFormat("HH:mm:ss").format(timeMeasurement.startedAtDate());
        this.response.add(String.format("%s %s R:%-4d W:%-4d I:%-4d E:%-4d %s\t(%s)\t%.03f seconds\n", this.passFail(summary), timeString, summary.right, summary.wrong, summary.ignores, summary.exceptions, page.getName(), this.getPath(page), timeMeasurement.elapsedSeconds()));
    }

    private String passFail(TestSummary summary) {
        if (summary.wrong > 0) {
            return "F";
        }
        if (summary.exceptions > 0) {
            return "X";
        }
        return ".";
    }

    @Override
    public void allTestingComplete(TimeMeasurement totalTimeMeasurement) throws Exception {
        super.allTestingComplete(totalTimeMeasurement);
        this.response.add(String.format("--------\n%d Tests,\t%d Failures\t%.03f seconds.\n", this.testCount, this.failCount, totalTimeMeasurement.elapsedSeconds()));
    }
}

