/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.search;

import fitnesse.VelocityFactory;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.components.SearchObserver;
import fitnesse.responders.ChunkingResponder;
import fitnesse.responders.templateUtilities.PageTitle;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import java.io.StringWriter;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;

public abstract class ResultResponder
extends ChunkingResponder
implements SearchObserver,
SecureResponder {
    private int hits;
    private int nextRow = 0;

    @Override
    protected PageCrawler getPageCrawler() {
        return this.root.getPageCrawler();
    }

    @Override
    protected void doSending() throws Exception {
        this.response.add(this.createSearchResultsHeader());
        this.startSearching();
        this.response.add(this.createSearchResultsFooter());
        this.response.closeAll();
    }

    private String createSearchResultsFooter() throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        StringWriter writer = new StringWriter();
        Template template = VelocityFactory.getVelocityEngine().getTemplate("searchResultsFooter.vm");
        if (this.page == null) {
            this.page = this.context.root.getPageCrawler().getPage(this.context.root, PathParser.parse("FrontPage"));
        }
        velocityContext.put("hits", this.hits);
        if (this.request.getQueryString() == null || this.request.getQueryString().equals("")) {
            velocityContext.put("request", this.request.getBody());
        } else {
            velocityContext.put("request", this.request.getQueryString());
        }
        velocityContext.put("page", this.page);
        template.merge(velocityContext, writer);
        return writer.toString();
    }

    private String createSearchResultsHeader() throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        StringWriter writer = new StringWriter();
        Template template = VelocityFactory.getVelocityEngine().getTemplate("searchResultsHeader.vm");
        velocityContext.put("page_title", this.getTitle());
        velocityContext.put("pageTitle", new PageTitle(this.getTitle()){

            @Override
            public String getTitle() {
                return "search";
            }

            @Override
            public String getLink() {
                return "search";
            }
        });
        template.merge(velocityContext, writer);
        return writer.toString();
    }

    public static String getDateFormatJavascriptRegex() {
        return "/^(\\w+) (jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec) (\\d+) (\\d+).(\\d+).(\\d+) (\\w+) (\\d+)$/";
    }

    @Override
    public void hit(WikiPage page) throws Exception {
        ++this.hits;
        this.response.add(this.createSearchResultsEntry(page));
    }

    private String createSearchResultsEntry(WikiPage result) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        StringWriter writer = new StringWriter();
        Template template = VelocityFactory.getVelocityEngine().getTemplate("searchResultsEntry.vm");
        velocityContext.put("resultsRow", this.getRow());
        velocityContext.put("result", result);
        template.merge(velocityContext, writer);
        return writer.toString();
    }

    private int getRow() {
        return this.nextRow++ % 2 + 1;
    }

    protected abstract String getTitle() throws Exception;

    protected abstract String getPageFooterInfo(int var1) throws Exception;

    protected void startSearching() throws Exception {
        this.hits = 0;
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }
}

