/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.Jsr223Bridge;
import fitnesse.slim.StatementExecutorInterface;
import java.io.PrintWriter;
import java.io.StringWriter;

public abstract class Jsr223StatementExecutor
implements StatementExecutorInterface {
    protected Jsr223Bridge bridge;
    private Object statementExecutorProxy;

    public Jsr223StatementExecutor(Jsr223Bridge bridge) throws Exception {
        this.bridge = bridge;
        this.statementExecutorProxy = bridge.getStatementExecutor();
    }

    protected Object getStatementExecutorProxy() {
        return this.statementExecutorProxy;
    }

    @Override
    public Object addPath(String path) {
        return this.callMethod("addPath", path);
    }

    @Override
    public Object call(String instanceName, String methodName, Object ... args) {
        return this.callMethod("call", instanceName, methodName, args);
    }

    @Override
    public Object create(String instanceName, String className, Object[] args) {
        return this.callMethod("create", instanceName, className, args);
    }

    @Override
    public Object getInstance(String instanceName) {
        return this.callMethod("getInstance", instanceName);
    }

    @Override
    public void setVariable(String name, Object value) {
        this.callMethod("setVariable", name, value);
    }

    @Override
    public boolean stopHasBeenRequested() {
        return (Boolean)this.callMethod("stopHasBeenRequested", new Object[0]);
    }

    @Override
    public void reset() {
        this.callMethod("reset", new Object[0]);
    }

    protected Object callMethod(String method, Object ... args) {
        try {
            return this.bridge.invokeMethod(this.getStatementExecutorProxy(), method, args);
        }
        catch (Throwable e) {
            return this.exceptionToString(e);
        }
    }

    private String exceptionToString(Throwable exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter pw = new PrintWriter(stringWriter);
        exception.printStackTrace(pw);
        return "__EXCEPTION__:" + stringWriter.toString();
    }
}

