/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.converters;

import fitnesse.slim.Converter;
import fitnesse.slim.SlimError;
import fitnesse.slim.converters.ListConverter;
import java.util.Arrays;

public class BooleanArrayConverter
implements Converter {
    @Override
    public String toString(Object o) {
        if (o == null) {
            return "null";
        }
        Boolean[] booleans = (Boolean[])o;
        return Arrays.asList(booleans).toString();
    }

    @Override
    public Object fromString(String arg) {
        String[] strings = ListConverter.fromStringToArrayOfStrings(arg);
        Boolean[] booleans = new Boolean[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            try {
                booleans[i] = Boolean.parseBoolean(strings[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new SlimError("message:<<CANT_CONVERT_TO_BOOLEAN_LIST>>");
            }
        }
        return booleans;
    }
}

