/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.FileSystemPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageCrawlerImpl;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.ProxyPage;
import fitnesse.wiki.SymbolicPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageAction;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageProperties;
import fitnesse.wiki.WikiPageProperty;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import util.EnvironmentVariableTool;
import util.FileUtil;

public abstract class BaseWikiPage
implements WikiPage {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected WikiPage parent;
    protected WikiPage parentForVariables;

    protected BaseWikiPage(String name, WikiPage parent) {
        this.name = name;
        this.parent = this.parentForVariables = parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PageCrawler getPageCrawler() {
        return new PageCrawlerImpl();
    }

    @Override
    public WikiPage getParent() {
        return this.parent == null ? this : this.parent;
    }

    @Override
    public void setParentForVariables(WikiPage parent) {
        this.parentForVariables = parent;
    }

    @Override
    public WikiPage getParentForVariables() {
        return this.parentForVariables == null ? this : this.parentForVariables;
    }

    protected abstract List<WikiPage> getNormalChildren() throws Exception;

    @Override
    public List<WikiPage> getChildren() throws Exception {
        List<WikiPage> children = this.getNormalChildren();
        WikiPageProperties props = this.getData().getProperties();
        WikiPageProperty symLinksProperty = props.getProperty("SymbolicLinks");
        if (symLinksProperty != null) {
            for (String linkName : symLinksProperty.keySet()) {
                WikiPage page = this.createSymbolicPage(symLinksProperty, linkName);
                if (page == null || children.contains(page)) continue;
                children.add(page);
            }
        }
        return children;
    }

    private WikiPage createSymbolicPage(WikiPageProperty symLinkProperty, String linkName) throws Exception {
        if (symLinkProperty == null) {
            return null;
        }
        String linkPath = symLinkProperty.get(linkName);
        if (linkPath == null) {
            return null;
        }
        if (linkPath.startsWith("file://")) {
            return this.createExternalSymbolicLink(linkPath, linkName);
        }
        return this.createInternalSymbolicPage(linkPath, linkName);
    }

    private WikiPage createExternalSymbolicLink(String linkPath, String linkName) throws Exception {
        String fullPagePath = EnvironmentVariableTool.replace(linkPath.substring(7));
        File file = new File(fullPagePath);
        File parentDirectory = file.getParentFile();
        if (parentDirectory.exists()) {
            if (!file.exists()) {
                FileUtil.makeDir(file.getPath());
            }
            if (file.isDirectory()) {
                FileSystemPage externalRoot = new FileSystemPage(parentDirectory.getPath(), file.getName());
                return new SymbolicPage(linkName, externalRoot, this);
            }
        }
        return null;
    }

    protected WikiPage createInternalSymbolicPage(String linkPath, String linkName) throws Exception {
        WikiPagePath path = PathParser.parse(linkPath);
        WikiPage start = path.isRelativePath() ? this.getParent() : this;
        WikiPage page = this.getPageCrawler().getPage(start, path);
        if (page != null) {
            page = new SymbolicPage(linkName, page, this);
        }
        return page;
    }

    protected abstract WikiPage getNormalChildPage(String var1) throws Exception;

    @Override
    public WikiPage getChildPage(String name) throws Exception {
        WikiPage page = this.getNormalChildPage(name);
        if (page == null) {
            page = this.createSymbolicPage(this.getData().getProperties().getProperty("SymbolicLinks"), name);
        }
        return page;
    }

    @Override
    public WikiPage getHeaderPage() throws Exception {
        return PageCrawlerImpl.getClosestInheritedPage("PageHeader", this);
    }

    @Override
    public WikiPage getFooterPage() throws Exception {
        return PageCrawlerImpl.getClosestInheritedPage("PageFooter", this);
    }

    @Override
    public List<WikiPageAction> getActions() throws Exception {
        String localPageName;
        WikiPagePath localPagePath = this.getPageCrawler().getFullPath(this);
        String localOrRemotePageName = localPageName = PathParser.render(localPagePath);
        boolean newWindowIfRemote = false;
        if (this instanceof ProxyPage) {
            ProxyPage proxyPage = (ProxyPage)this;
            localOrRemotePageName = proxyPage.getThisPageUrl();
            newWindowIfRemote = true;
        }
        return this.makeActions(localPageName, localOrRemotePageName, newWindowIfRemote);
    }

    private List<WikiPageAction> makeActions(String localPageName, String localOrRemotePageName, boolean newWindowIfRemote) throws Exception {
        PageData pageData = this.getData();
        ArrayList<WikiPageAction> actions = new ArrayList<WikiPageAction>();
        this.addActionForAttribute("Test", pageData, localPageName, newWindowIfRemote, null, null, actions);
        this.addActionForAttribute("Suite", pageData, localPageName, newWindowIfRemote, "", null, actions);
        this.addActionForAttribute("Edit", pageData, localOrRemotePageName, newWindowIfRemote, null, null, actions);
        this.addActionForAttribute("Properties", pageData, localOrRemotePageName, newWindowIfRemote, null, null, actions);
        this.addActionForAttribute("Refactor", pageData, localOrRemotePageName, newWindowIfRemote, null, null, actions);
        this.addActionForAttribute("Where Used", pageData, localOrRemotePageName, newWindowIfRemote, null, "whereUsed", actions);
        this.addActionForAttribute("Search", pageData, "", newWindowIfRemote, null, "searchForm", actions);
        this.addActionForAttribute("Files", pageData, "/files", newWindowIfRemote, null, "", actions);
        this.addActionForAttribute("Versions", pageData, localOrRemotePageName, newWindowIfRemote, null, null, actions);
        this.addActionForAttribute("Recent Changes", pageData, "/RecentChanges", newWindowIfRemote, "", "", actions);
        this.addAction("User Guide", ".FitNesse.UserGuide", newWindowIfRemote, "", "", actions);
        this.addAction("Test History", "?testHistory", newWindowIfRemote, "", "", actions);
        return actions;
    }

    private void addActionForAttribute(String attribute, PageData pageData, String pageName, boolean newWindowIfRemote, String shortcutKey, String query, List<WikiPageAction> actions) {
        if (pageData.hasAttribute(attribute.replaceAll("\\s", ""))) {
            this.addAction(attribute, pageName, newWindowIfRemote, shortcutKey, query, actions);
        }
    }

    private void addAction(String linkName, String pageName, boolean newWindowIfRemote, String shortcutKey, String query, List<WikiPageAction> actions) {
        WikiPageAction link = new WikiPageAction(pageName, linkName);
        link.setNewWindow(newWindowIfRemote);
        if (shortcutKey != null) {
            link.setShortcutKey(shortcutKey);
        }
        if (query != null) {
            link.setQuery(query);
        }
        actions.add(link);
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.name;
    }

    @Override
    public int compareTo(Object o) {
        try {
            return this.getName().compareTo(((WikiPage)o).getName());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WikiPage)) {
            return false;
        }
        try {
            PageCrawler crawler = this.getPageCrawler();
            return crawler.getFullPath(this).equals(crawler.getFullPath((WikiPage)o));
        }
        catch (Exception e) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return this.getPageCrawler().getFullPath(this).hashCode();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public String getHelpText() throws Exception {
        String helpText = this.getData().getAttribute("Help");
        return helpText == null || helpText.length() == 0 ? null : helpText;
    }
}

