/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.ComponentFactory;
import fitnesse.wiki.CommitingPage;
import fitnesse.wiki.NoSuchVersionException;
import fitnesse.wiki.PageData;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.VirtualCouplingExtension;
import fitnesse.wiki.WikiPage;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import util.Clock;
import util.FileSystem;

public class InMemoryPage
extends CommitingPage {
    private static final long serialVersionUID = 1L;
    protected static final String currentVersionName = "current_version";
    protected Map<String, PageData> versions = new ConcurrentHashMap<String, PageData>();
    protected Map<String, WikiPage> children = new ConcurrentHashMap<String, WikiPage>();

    public InMemoryPage(String rootPath, String rootPageName, ComponentFactory factory) throws Exception {
        this(rootPageName, null);
    }

    public InMemoryPage(String rootPath, String rootPageName, FileSystem fileSystem, ComponentFactory factory) throws Exception {
        this(rootPageName, null);
    }

    protected InMemoryPage(String name, WikiPage parent) throws Exception {
        super(name, parent);
        this.addExtention(new VirtualCouplingExtension(this));
        this.versions.put(currentVersionName, new PageData(this, ""));
    }

    @Override
    public WikiPage addChildPage(String name) throws Exception {
        WikiPage page = this.createChildPage(name);
        this.children.put(name, page);
        return page;
    }

    public static WikiPage makeRoot(String name) throws Exception {
        return new InMemoryPage(name, null);
    }

    protected WikiPage createChildPage(String name) throws Exception {
        InMemoryPage newPage = new InMemoryPage(name, this);
        this.children.put(newPage.getName(), newPage);
        return newPage;
    }

    @Override
    public void removeChildPage(String name) throws Exception {
        this.children.remove(name);
    }

    @Override
    public boolean hasChildPage(String pageName) {
        return this.children.containsKey(pageName);
    }

    @Override
    protected VersionInfo makeVersion() throws Exception {
        PageData current = this.getDataVersion(currentVersionName);
        String name = String.valueOf(VersionInfo.nextId());
        VersionInfo version = this.makeVersionInfo(current, name);
        this.versions.put(version.getName(), current);
        return version;
    }

    @Override
    protected WikiPage getNormalChildPage(String name) throws Exception {
        return this.children.get(name);
    }

    @Override
    public List<WikiPage> getNormalChildren() {
        return new LinkedList<WikiPage>(this.children.values());
    }

    @Override
    public PageData getData() throws Exception {
        return new PageData(this.getDataVersion(currentVersionName));
    }

    @Override
    public void doCommit(PageData newData) throws Exception {
        newData.setWikiPage(this);
        newData.getProperties().setLastModificationTime(Clock.currentDate());
        this.versions.put(currentVersionName, newData);
    }

    @Override
    public PageData getDataVersion(String versionName) throws Exception {
        PageData version = this.versions.get(versionName);
        if (version == null) {
            throw new NoSuchVersionException("There is no version '" + versionName + "'");
        }
        HashSet<String> names = new HashSet<String>(this.versions.keySet());
        names.remove(currentVersionName);
        LinkedList<VersionInfo> pageVersions = new LinkedList<VersionInfo>();
        for (String name : names) {
            PageData data = this.versions.get(name);
            pageVersions.add(this.makeVersionInfo(data, name));
        }
        version.addVersions(pageVersions);
        return new PageData(version);
    }

    public int numberOfVersions() {
        return this.versions.size() - 1;
    }

    protected VersionInfo makeVersionInfo(PageData current, String name) throws Exception {
        String author = current.getAttribute("LastModifyingUser");
        if (author == null) {
            author = "";
        }
        Date date = current.getProperties().getLastModificationTime();
        return new VersionInfo(name, author, date);
    }
}

