/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

public class WikiPageAction {
    private String pageName;
    private String linkName;
    private String query;
    private String shortcutKey;
    private boolean newWindow;

    public WikiPageAction(String pageName, String linkName) {
        this.pageName = pageName;
        this.linkName = linkName;
        this.query = linkName.toLowerCase();
        this.shortcutKey = this.query.substring(0, 1);
        this.newWindow = false;
    }

    public String getPageName() {
        return this.pageName;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public String getQuery() {
        return this.query;
    }

    public String getShortcutKey() {
        return this.shortcutKey;
    }

    public boolean isNewWindow() {
        return this.newWindow;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }

    public void setQuery(String inputName) {
        this.query = inputName;
    }

    public void setShortcutKey(String shortcutKey) {
        this.shortcutKey = shortcutKey;
    }

    public void setNewWindow(boolean newWindow) {
        this.newWindow = newWindow;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WikiPageAction that = (WikiPageAction)o;
        if (this.newWindow != that.newWindow) {
            return false;
        }
        return this.eq(this.linkName, that.linkName) && this.eq(this.pageName, that.pageName) && this.eq(this.query, that.query) && this.eq(this.shortcutKey, that.shortcutKey);
    }

    private boolean eq(String thisString, String thatString) {
        return thisString != null && thatString != null && thisString.equals(thatString) || thisString == null && thatString == null;
    }

    public int hashCode() {
        int hashSum = this.hashString(this.pageName);
        hashSum = this.addToHash(hashSum, this.hashString(this.linkName));
        hashSum = this.addToHash(hashSum, this.hashString(this.query));
        hashSum = this.addToHash(hashSum, this.hashString(this.shortcutKey));
        hashSum = this.addToHash(hashSum, this.newWindow ? 1 : 0);
        return hashSum;
    }

    private int addToHash(int hashSum, int hashCode) {
        return 31 * hashSum + hashCode;
    }

    private int hashString(String string) {
        return string != null ? string.hashCode() : 0;
    }
}

