/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.Link;
import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import util.Maybe;

public class Image
extends SymbolType
implements Rule {
    public static final Image symbolType = new Image();

    public Image() {
        super("Image");
        this.wikiMatcher(new Matcher().string("!img-l"));
        this.wikiMatcher(new Matcher().string("!img-r"));
        this.wikiMatcher(new Matcher().string("!img"));
        this.wikiRule(this);
    }

    @Override
    public Maybe<Symbol> parse(Symbol current, Parser parser) {
        String imageProperty = current.getContent().endsWith("l") ? "left" : (current.getContent().endsWith("r") ? "right" : "");
        parser.moveNext(1);
        if (!parser.getCurrent().isType(SymbolType.Whitespace)) {
            return Symbol.nothing;
        }
        parser.moveNext(1);
        if (parser.getCurrent().isType(Link.symbolType)) {
            Maybe<Symbol> link = Link.symbolType.getWikiRule().parse(parser.getCurrent(), parser);
            if (link.isNothing()) {
                return Symbol.nothing;
            }
            return this.makeImageLink(link.getValue(), imageProperty);
        }
        if (parser.getCurrent().isType(SymbolType.Text)) {
            Symbol list = new Symbol(SymbolType.SymbolList).add(parser.getCurrent());
            return this.makeImageLink(new Symbol(Link.symbolType).add(list), imageProperty);
        }
        return Symbol.nothing;
    }

    private Maybe<Symbol> makeImageLink(Symbol link, String imageProperty) {
        return new Maybe<Symbol>(link.putProperty("image", imageProperty));
    }
}

