/*
 * Decompiled with CFR 0.152.
 */
package fitnesseMain.ant;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import util.StringUtil;

public class ExecuteFitnesseTestsTask
extends Task {
    private String fitnesseHost = "localhost";
    private int fitnessePort;
    private String suitePage;
    private String suiteFilter;
    private String resultsDir = ".";
    private String resultsHTMLPage;
    private String resultsXMLPage;
    private boolean debug = true;
    private boolean verbose = true;
    private boolean failOnError = true;
    private String testRunnerClass = "fitnesse.runner.TestRunner";
    private Path classpath;
    private String resultProperty;

    public void execute() throws BuildException {
        try {
            int exitCode = this.executeRunnerClassAsForked();
            if (exitCode != 0) {
                this.log("Finished executing FitNesse tests: " + exitCode + " failures/exceptions");
                if (this.failOnError) {
                    throw new BuildException(exitCode + " FitNesse test failures/exceptions");
                }
                this.getProject().setNewProperty(this.resultProperty, String.valueOf(exitCode));
            } else {
                this.log("Fitnesse Tests executed successfully");
            }
        }
        catch (Exception e) {
            if (this.failOnError) {
                throw new BuildException("Got an unexpected error trying to run the fitnesse tests : " + e.getMessage(), (Throwable)e);
            }
            e.printStackTrace();
        }
    }

    private int executeRunnerClassAsForked() throws BuildException {
        int retVal;
        CommandlineJava cmd = this.initializeJavaCommand();
        Execute execute = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 1));
        String[] commandLine = cmd.getCommandline();
        System.out.printf("Executing: %s\n", StringUtil.join(Arrays.asList(commandLine), " "));
        execute.setCommandline(commandLine);
        execute.setNewenvironment(false);
        execute.setAntRun(this.getProject());
        this.log(cmd.describeCommand(), 3);
        try {
            retVal = execute.execute();
        }
        catch (IOException e) {
            throw new BuildException("Process fork failed.", (Throwable)e, this.getLocation());
        }
        return retVal;
    }

    private CommandlineJava initializeJavaCommand() {
        CommandlineJava cmd = new CommandlineJava();
        cmd.setClassname(this.testRunnerClass);
        this.appendDebugArgument(cmd);
        this.appendVerboseArgument(cmd);
        this.appendHtmlResultPage(cmd);
        this.appendXmlResultPage(cmd);
        this.appendSuiteFilter(cmd);
        cmd.createArgument().setValue(this.fitnesseHost);
        cmd.createArgument().setValue(String.valueOf(this.fitnessePort));
        cmd.createArgument().setValue(this.suitePage);
        cmd.createClasspath(this.getProject()).createPath().append(this.classpath);
        return cmd;
    }

    private void appendDebugArgument(CommandlineJava cmd) {
        if (this.debug) {
            cmd.createArgument().setValue("-debug");
        }
    }

    private void appendVerboseArgument(CommandlineJava cmd) {
        if (this.verbose) {
            cmd.createArgument().setValue("-v");
        }
    }

    private void appendHtmlResultPage(CommandlineJava cmd) {
        if (this.resultsHTMLPage != null) {
            String resultsHTMLPagePath = new File(this.resultsDir, this.resultsHTMLPage).getAbsolutePath();
            cmd.createArgument().setValue("-html");
            cmd.createArgument().setValue(resultsHTMLPagePath);
        }
    }

    private void appendXmlResultPage(CommandlineJava cmd) {
        if (this.resultsXMLPage != null) {
            String resultsHTMLPagePath = new File(this.resultsDir, this.resultsXMLPage).getAbsolutePath();
            cmd.createArgument().setValue("-xml");
            cmd.createArgument().setValue(resultsHTMLPagePath);
        }
    }

    private void appendSuiteFilter(CommandlineJava cmd) {
        if (this.suiteFilter != null) {
            cmd.createArgument().setValue("-suiteFilter");
            cmd.createArgument().setValue(this.suiteFilter);
        }
    }

    public void setFitnesseHost(String fitnesseHost) {
        this.fitnesseHost = fitnesseHost;
    }

    public void setClasspath(Path classpath) {
        this.classpath = classpath;
    }

    public void setSuiteFilter(String suiteFilter) {
        this.suiteFilter = suiteFilter;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setFitnessePort(int fitnessePort) {
        this.fitnessePort = fitnessePort;
    }

    public void setResultProperty(String resultProperty) {
        this.resultProperty = resultProperty;
    }

    public void setResultsDir(String resultsDir) {
        this.resultsDir = resultsDir;
    }

    public void setResultsHTMLPage(String resultsHTMLPage) {
        this.resultsHTMLPage = resultsHTMLPage;
    }

    public void setResultsXMLPage(String resultsXMLPage) {
        this.resultsXMLPage = resultsXMLPage;
    }

    public void setTestRunnerClass(String runnerClass) {
        this.testRunnerClass = runnerClass;
    }

    public void setSuitePage(String suitePage) {
        this.suitePage = suitePage;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }
}

