/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.field.FBField;

class FBDateField
extends FBField {
    FBDateField(XSQLVAR field, FBResultSet rs, int numCol, int requiredType) throws SQLException {
        super(field, rs, numCol, requiredType);
    }

    public Timestamp getTimestamp(Calendar cal) throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return TIMESTAMP_NULL_VALUE;
        }
        return this.field.decodeTimestamp(this.getTimestamp(), cal);
    }

    public Timestamp getTimestamp() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return TIMESTAMP_NULL_VALUE;
        }
        return new Timestamp(this.getDate().getTime());
    }

    public Date getDate(Calendar cal) throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return DATE_NULL_VALUE;
        }
        return this.field.decodeDate(this.getDate(), cal);
    }

    public Date getDate() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return DATE_NULL_VALUE;
        }
        return this.field.decodeDate(this.rs.row[this.numCol]);
    }

    public String getString() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return STRING_NULL_VALUE;
        }
        return this.field.decodeDate(this.rs.row[this.numCol]).toString();
    }

    public void setString(String value) throws SQLException {
        if (value == STRING_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setDate(Date.valueOf(value));
    }

    public void setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        if (value == TIMESTAMP_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setTimestamp(this.field.encodeTimestamp(value, cal));
    }

    public void setTimestamp(Timestamp value) throws SQLException {
        if (value == TIMESTAMP_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setDate(new Date(value.getTime()));
    }

    public void setDate(Date value, Calendar cal) throws SQLException {
        if (value == DATE_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setDate(this.field.encodeDate(value, cal));
    }

    public void setDate(Date value) throws SQLException {
        if (value == DATE_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.field.sqldata = this.field.encodeDate(value);
    }
}

