/*
 * Decompiled with CFR 0.152.
 */
package fit.decorator.util;

import fit.decorator.util.ClassDelegatePointParser;
import java.awt.Point;
import junit.framework.TestCase;

public class ClassDelegatePointParserTest
extends TestCase {
    public void testParseMethodReturnsPointClassFromGivenString() throws Exception {
        ClassDelegatePointParserTest.assertEquals((Object)new Point(1, 2), (Object)ClassDelegatePointParser.parse("(1,2)"));
        ClassDelegatePointParserTest.assertEquals((Object)new Point(2, -1), (Object)ClassDelegatePointParser.parse("(2,-1)"));
        ClassDelegatePointParserTest.assertEquals((Object)new Point(-99999, 99999), (Object)ClassDelegatePointParser.parse("(-99999,99999)"));
    }

    public void testShouldThrowAnExceptionIfFormatOfTheInputStringIsNotWelformed() throws Exception {
        this.assertParseException("(,)");
        this.assertParseException("(2,)");
        this.assertParseException("(,2)");
        this.assertParseException("(22)");
        this.assertParseException("222,)");
        this.assertParseException("(,222");
    }

    private void assertParseException(String point) {
        try {
            ClassDelegatePointParser.parse(point);
            ClassDelegatePointParserTest.fail((String)"Should throw an exception");
        }
        catch (IllegalArgumentException e) {
            ClassDelegatePointParserTest.assertEquals((String)(point + " is not a valid format. (x,y) is the correct format"), (String)e.getMessage());
        }
    }
}

