/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary;

import fit.Fixture;
import fit.Parse;
import fitlibrary.annotation.ShowSelectedActions;
import fitlibrary.dynamicVariable.DynamicVariables;
import fitlibrary.flow.IScope;
import fitlibrary.parser.lookup.ParseDelegation;
import fitlibrary.runResults.TestResults;
import fitlibrary.runResults.TestResultsFactory;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.Traverse;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.Pair;

@ShowSelectedActions
public abstract class FitLibraryFixture
extends Fixture
implements Evaluator {
    private Traverse traverse;
    private TypedObject typedObjectUnderTest = Traverse.asTypedObject(null);

    protected void registerParseDelegate(Class<?> type, Class<?> parseDelegate) {
        ParseDelegation.registerParseDelegate(type, parseDelegate);
    }

    protected void registerParseDelegate(Class<?> type, Object parseDelegate) {
        ParseDelegation.registerParseDelegate(type, parseDelegate);
    }

    protected void registerSuperParseDelegate(Class<?> type, Object superParseDelegate) {
        ParseDelegation.registerSuperParseDelegate(type, superParseDelegate);
    }

    public void setSystemUnderTest(Object sut) {
        this.typedObjectUnderTest = Traverse.asTypedObject(sut);
    }

    @Override
    public Object getSystemUnderTest() {
        return this.typedObjectUnderTest.getSubject();
    }

    @Override
    public TypedObject getTypedSystemUnderTest() {
        return this.typedObjectUnderTest;
    }

    public final Traverse traverse() {
        return this.traverse;
    }

    protected void setTraverse(Traverse traverse) {
        this.traverse = traverse;
    }

    @Override
    public void doTable(Parse parseTable) {
        throw new RuntimeException("Please use FitLibraryServer instead of FitServer.");
    }

    public boolean doEmbeddedTablePasses(Table table, Evaluator evaluator, TestResults testResults) {
        return this.traverse().doesInnerTablePass(table, evaluator.getRuntimeContext(), testResults);
    }

    public TestResults createTestResults() {
        return TestResultsFactory.testResults(this.counts);
    }

    @Override
    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        return this.traverse().interpretAfterFirstRow(table, testResults);
    }

    @Override
    public RuntimeContextInternal getRuntimeContext() {
        return this.traverse().getRuntimeContext();
    }

    @Override
    public IScope getScope() {
        return this.getRuntimeContext().getScope();
    }

    public DynamicVariables getDynamicVariables() {
        return this.getRuntimeContext().getDynamicVariables();
    }

    @Override
    public void setRuntimeContext(RuntimeContextInternal propertyValues) {
        this.traverse().setRuntimeContext(propertyValues);
    }

    @Override
    public void setDynamicVariable(String key, Object value) {
        this.traverse().setDynamicVariable(key, value);
    }

    @Override
    public Pair<String, Tables> resolve(String key) {
        return this.traverse().resolve(key);
    }
}

