/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.collection;

import fitlibrary.closure.ClassMethodTarget;
import fitlibrary.closure.ConstantMethodTarget;
import fitlibrary.closure.ICalledMethodTarget;
import fitlibrary.closure.MethodTarget;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.exception.IgnoredException;
import fitlibrary.exception.method.NoSuchPropertyException;
import fitlibrary.object.DomainObjectSetUpTraverse;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.Traverse;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.ClassUtility;
import fitlibrary.utility.MapElement;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class CollectionTraverse
extends Traverse {
    protected boolean[] usedFields;
    protected Collection<Object> actuals;
    protected boolean showSurplus = true;
    private Class<?> componentType = null;

    protected CollectionTraverse(Object sut) {
        super(sut);
    }

    protected CollectionTraverse(Object sut, Object actuals) {
        super(sut);
        this.setActualCollection(actuals);
    }

    public void setActualCollection(Object actuals) {
        if (actuals instanceof Collection) {
            this.setActualCollection((Collection)actuals);
        } else if (actuals instanceof Iterator) {
            this.setActualCollection((Iterator)actuals);
        } else if (actuals instanceof Map) {
            this.setActualCollection((Map)actuals);
        } else if (actuals instanceof Object[]) {
            this.setActualCollection((Object[])actuals);
        } else if (actuals.getClass().isArray()) {
            this.setActualCollectionAsArray(actuals);
        } else {
            throw new RuntimeException("Unable to handle an object of type " + actuals.getClass());
        }
    }

    private void setActualCollectionAsArray(Object actuals) {
        ArrayList<Object> list = new ArrayList<Object>();
        int length = Array.getLength(actuals);
        for (int i = 0; i < length; ++i) {
            list.add(Array.get(actuals, i));
        }
        this.setActualCollection(list);
    }

    public void setActualCollection(Collection<Object> actuals) {
        this.actuals = actuals;
    }

    public void setActualCollection(Object[] actuals) {
        this.setActualCollection(Arrays.asList(actuals));
    }

    public void setActualCollection(Iterator<Object> it) {
        ArrayList<Object> actualCollection = new ArrayList<Object>();
        while (it.hasNext()) {
            actualCollection.add(it.next());
        }
        this.setActualCollection(actualCollection);
    }

    public void setActualCollection(Map<Object, Object> map) {
        this.setActualCollection(CollectionTraverse.mapMapToSet(map));
    }

    public static List<MapElement> mapMapToSet(Map<Object, Object> map) {
        ArrayList<MapElement> elements = new ArrayList<MapElement>();
        Set<Object> keySet = map.keySet();
        for (Object key : keySet) {
            elements.add(new MapElement(key, map.get(key)));
        }
        return elements;
    }

    @Override
    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        if (this.actuals == null) {
            throw new FitLibraryException("Actual list missing");
        }
        Row firstRow = (Row)table.at(1);
        try {
            ArrayList<MethodTarget[]> getters = new ArrayList();
            if (!this.actuals.isEmpty()) {
                getters = this.bindGettersForAllActuals(firstRow, testResults);
            } else if (!table.atExists(2)) {
                ((Row)table.at(1)).pass(testResults);
            }
            for (int rowNo = 2; rowNo < table.size(); ++rowNo) {
                firstRow = (Row)table.at(rowNo);
                this.interpretRow(firstRow, getters, testResults);
            }
            if (this.showSurplus) {
                this.showSurplus(getters, table, testResults);
            }
        }
        catch (IgnoredException e) {
        }
        catch (Exception e) {
            firstRow.error(testResults, e);
        }
        return this.actuals;
    }

    public void setShowSurplus(boolean showSurplus) {
        this.showSurplus = showSurplus;
    }

    public void setComponentType(Class<?> componentType) {
        this.componentType = componentType;
    }

    protected final List<MethodTarget[]> bindGettersForAllActuals(Row row, TestResults testResults) throws Exception {
        this.usedFields = new boolean[row.size()];
        for (int i = 0; i < this.usedFields.length; ++i) {
            this.usedFields[i] = false;
        }
        ArrayList<MethodTarget[]> bindings = new ArrayList<MethodTarget[]>();
        Iterator<Object> it = this.actuals.iterator();
        while (it.hasNext()) {
            TypedObject typedObject = CollectionTraverse.asTypedObject(it.next());
            bindings.add(this.bindGettersForOneElement(row, typedObject));
        }
        for (int i = 0; i < this.usedFields.length; ++i) {
            if (this.usedFields[i]) continue;
            String propertyName = this.extendedCamel(((Cell)row.at(i)).text(this));
            String classNames = ClassUtility.allElementClassNames(this.actuals);
            ((Cell)row.at(i)).error(testResults, new NoSuchPropertyException(propertyName, classNames));
            throw new IgnoredException();
        }
        return bindings;
    }

    private MethodTarget[] bindGettersForOneElement(Row row, TypedObject typedObject) {
        MethodTarget[] columnBindings = new MethodTarget[row.size()];
        for (int i = 0; i < columnBindings.length; ++i) {
            Cell cell = (Cell)row.at(i);
            if (this.componentType != null && DomainObjectSetUpTraverse.givesClass(cell, this)) {
                columnBindings[i] = new ClassMethodTarget(this.componentType, this, typedObject);
                this.usedFields[i] = true;
                continue;
            }
            try {
                columnBindings[i] = this.bindPropertyGetterForTypedObject(cell.text(this), typedObject);
                if (columnBindings[i] == null) continue;
                this.usedFields[i] = true;
                continue;
            }
            catch (NoSuchPropertyException e) {
                throw new IgnoredException();
            }
        }
        return columnBindings;
    }

    protected ICalledMethodTarget bindPropertyGetterForTypedObject(String name, TypedObject typedObject) {
        String mappedName = this.extendedCamel(name);
        if (typedObject.getSubject() instanceof Map) {
            Object value = ((Map)typedObject.getSubject()).get(mappedName);
            if (value == null) {
                value = ((Map)typedObject.getSubject()).get(name);
            }
            if (value == null) {
                return null;
            }
            return new ConstantMethodTarget(value, (Evaluator)this);
        }
        return typedObject.new_optionallyFindGetterOnTypedObject(name, this);
    }

    protected final boolean matchRow(Row row, MethodTarget[] columnBindings, TestResults testResults) throws Exception {
        boolean matchedAlready = false;
        for (int i = 0; i < columnBindings.length; ++i) {
            Cell expectedCell = (Cell)row.at(i);
            MethodTarget getter = columnBindings[i];
            if (getter == null) {
                expectedCell.passOrFailIfBlank(testResults, this);
                continue;
            }
            boolean matched = getter.invokeAndCheckCell(expectedCell, matchedAlready, testResults);
            if (!matchedAlready && !matched) {
                return false;
            }
            matchedAlready = true;
        }
        return true;
    }

    protected void showSurplus(List<MethodTarget[]> bindings, Table table, TestResults testResults) {
        if (!bindings.isEmpty()) {
            CollectionTraverse.addSurplusRows(table, bindings, testResults);
        }
    }

    private static void addSurplusRows(Table table, List<MethodTarget[]> surplusBindings, TestResults testResults) {
        for (MethodTarget[] getter : surplusBindings) {
            Row row = table.newRow();
            CollectionTraverse.buildSurplusRow(row, CollectionTraverse.getValues(getter), testResults);
            ((Cell)row.at(0)).actualElementMissing(testResults);
        }
    }

    private static void buildSurplusRow(Row row, Object[] values, TestResults testResults) {
        if (values.length == 0) {
            row.addCell("null", values.length);
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            Cell addCell = row.addCell("&nbsp;");
            Object value = values[i];
            if (value == null) {
                addCell.ignore(testResults);
                continue;
            }
            if (value instanceof Exception) {
                addCell.error(testResults, (Exception)value);
                continue;
            }
            addCell.setUnvisitedEscapedText(value.toString());
        }
    }

    private static Object[] getValues(MethodTarget[] getters) {
        Object[] values = new Object[getters.length];
        for (int i = 0; i < getters.length; ++i) {
            MethodTarget getter = getters[i];
            if (getter == null) {
                values[i] = null;
                continue;
            }
            try {
                values[i] = getter.getResult();
                continue;
            }
            catch (Exception e) {
                values[i] = e;
            }
        }
        return values;
    }

    public abstract void interpretRow(Row var1, List<MethodTarget[]> var2, TestResults var3) throws Exception;
}

