/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.collection.array;

import fitlibrary.exception.table.RowWrongWidthException;
import fitlibrary.parser.Parser;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.traverse.Traverse;
import fitlibrary.typed.TypedObject;
import fitlibraryGeneric.typed.GenericTypedObject;
import java.lang.reflect.Array;

public class ArrayTraverse
extends Traverse {
    private final TypedObject typedArray;
    private Parser parser;
    private boolean embedded = false;

    public ArrayTraverse(Object array) {
        this.typedArray = new GenericTypedObject(array);
    }

    public ArrayTraverse(TypedObject typedArray) {
        this.typedArray = typedArray;
    }

    public ArrayTraverse(Object array, boolean embedded) {
        this(array);
        this.embedded = embedded;
    }

    @Override
    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        Row row;
        int rowNo;
        this.parser = this.typedArray.getTyped().getComponentTyped().parser(this);
        int offset = 0;
        if (!this.embedded) {
            offset = 1;
        }
        int arrayLength = Array.getLength(this.typedArray.getSubject());
        int tableSize = table.size();
        if (tableSize == offset && arrayLength == 0 && offset == 1) {
            ((Cell)((Row)table.at(0)).at(0)).pass(testResults);
        }
        int arrayIndex = 0;
        for (rowNo = offset; rowNo < tableSize && arrayIndex < arrayLength; ++rowNo) {
            row = (Row)table.at(rowNo);
            try {
                if (row.size() != 1) {
                    throw new RowWrongWidthException(1);
                }
                if (this.parser.matches((Cell)row.at(0), this.get(arrayIndex), testResults)) {
                    row.pass(testResults);
                    ++arrayIndex;
                    continue;
                }
                ((Cell)row.at(0)).expectedElementMissing(testResults);
                continue;
            }
            catch (Exception e) {
                row.error(testResults, e);
            }
        }
        while (rowNo < tableSize) {
            ((Row)table.at(rowNo)).missing(testResults);
            ++rowNo;
        }
        while (arrayIndex < arrayLength) {
            row = table.newRow();
            Cell cell = row.addCell();
            try {
                cell.actualElementMissing(testResults, this.parser.show(this.get(arrayIndex)));
            }
            catch (Exception e) {
                cell.error(testResults, e);
            }
            ++arrayIndex;
        }
        return this.typedArray.getSubject();
    }

    private Object get(int rowNo) {
        return Array.get(this.typedArray.getSubject(), rowNo);
    }
}

