/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.debug;

import fit.FitServerBridge;
import fit.exception.FitParseException;
import fitlibrary.batch.fitnesseIn.ParallelFitNesseRepository;
import fitlibrary.differences.FitNesseLocalFile;
import fitlibrary.log.ConfigureLoggingThroughFiles;
import fitlibrary.runResults.TableListener;
import fitlibrary.runResults.TestResults;
import fitlibrary.suite.BatchFitLibrary;
import fitlibrary.suite.ReportListener;
import fitlibrary.table.Table;
import fitlibrary.table.TableFactory;
import fitlibrary.table.Tables;
import java.io.IOException;

public class DebugPage {
    private final String fitNesseDiry;
    private final int port;
    protected int tablesFinished = 0;
    protected int storytestsFinished = 0;
    protected int expectedTablesFinished = 0;
    protected ReportListener reportListener = new ReportListener(){

        @Override
        public void tableFinished(Table table) {
            ++DebugPage.this.tablesFinished;
        }

        @Override
        public void tablesFinished(TestResults testResults) {
            ++DebugPage.this.storytestsFinished;
        }
    };
    BatchFitLibrary batchFitLibrary = new BatchFitLibrary(new TableListener(this.reportListener));

    public DebugPage(String fitNesseDiry, int port) {
        this.fitNesseDiry = fitNesseDiry;
        this.port = port;
    }

    public void debugPages(String[] pageNames) throws FitParseException, IOException {
        ConfigureLoggingThroughFiles.configure(this.fitNesseDiry + "/");
        FitNesseLocalFile.fitNessePrefix(this.fitNesseDiry);
        this.tablesFinished = 0;
        this.storytestsFinished = 0;
        for (int i = 0; i < pageNames.length; ++i) {
            this.runPage(pageNames[i]);
            if (this.storytestsFinished == i + 1) continue;
            throw new RuntimeException("Wrong # of FixtureListener events fired for " + pageNames[i] + ": " + this.storytestsFinished + " instead of " + (i + 1));
        }
        if (this.tablesFinished != this.expectedTablesFinished) {
            throw new RuntimeException("Expected FixtureListener events for " + this.expectedTablesFinished + " tables but instead got " + this.tablesFinished);
        }
    }

    public void runPage(String pageName) throws IOException, FitParseException {
        String html = new ParallelFitNesseRepository(this.fitNesseDiry, this.port).getTest(pageName).getContent();
        System.out.println("\n----------\nHTML for " + pageName + "\n----------\n" + html);
        Tables tables = TableFactory.tables(html);
        this.expectedTablesFinished += tables.size();
        FitServerBridge.setFitNesseUrl("http://localhost:" + this.port);
        TestResults testResults = this.batchFitLibrary.doStorytest(tables);
        System.out.println("\n----------\nHTML Report for " + pageName + "\n----------\n" + tables.report());
        System.out.println(testResults);
    }

    public static void main(String[] args) throws Exception {
        String[] fullPageNames = new String[]{"FitLibrary.SpecifiCations.DoWorkflow.TestActions"};
        String FITNESSE_DIRY = "fitnesse";
        int PORT = 8990;
        DebugPage.run(fullPageNames, "fitnesse", 8990);
    }

    public static void run(String[] fullPageNames, String fitNesseDiry, int port) throws Exception {
        DebugPage debugPage = new DebugPage(fitNesseDiry, port);
        debugPage.debugPages(fullPageNames);
    }
}

