/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.differences;

import fitlibrary.differences.DifferenceInterface;
import fitlibrary.differences.FitNesseLocalFile;
import fitlibrary.differences.LocalFile;
import java.io.File;

public class FitNesseDifference
implements DifferenceInterface {
    protected static final String LOCAL_FILES = "/files";
    protected static final String FITNESSE_FILES_LOCATION = "FitNesseRoot/files";

    public File getRelativeFile(String name) {
        return new File(this.getHomeDirectory(), name);
    }

    public File getHomeDirectory() {
        File fitNesse = new File(FITNESSE_FILES_LOCATION);
        if (!fitNesse.exists() || !fitNesse.isDirectory()) {
            throw new RuntimeException("The FitNesse directories have changed: " + fitNesse.getAbsolutePath());
        }
        return fitNesse;
    }

    public String url(String fileName) {
        return "/files/" + fileName;
    }

    @Override
    public LocalFile getLocalFile(String fileName) {
        return new FitNesseLocalFile(fileName);
    }

    @Override
    public LocalFile getLocalFile(File file) {
        return new FitNesseLocalFile(file);
    }

    @Override
    public LocalFile getGlobalFile(File file) {
        return this.getLocalFile(file);
    }

    @Override
    public LocalFile getGlobalFile(String fileName) {
        return this.getLocalFile(fileName);
    }

    @Override
    public void setContext(File file) {
        throw new RuntimeException("This should never be called, as the FolderRunner calls it.");
    }

    @Override
    public boolean inFitNesse() {
        return true;
    }
}

