/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.dynamicVariable;

import fitlibrary.dynamicVariable.DynamicVariables;
import fitlibrary.dynamicVariable.LocalDynamicVariables;
import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestLocalDynamicVariables {
    Mockery context = new Mockery();
    protected DynamicVariables vars = (DynamicVariables)this.context.mock(DynamicVariables.class);

    @Test
    public void global() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DynamicVariables)this.one(TestLocalDynamicVariables.this.vars)).get("k");
                this.will(1.returnValue((Object)"v"));
            }
        });
        LocalDynamicVariables localDynamicVariables = new LocalDynamicVariables(this.vars);
        MatcherAssert.assertThat((Object)localDynamicVariables.get("k").toString(), (Matcher)CoreMatchers.is((Object)"v"));
    }

    @Test
    public void put() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DynamicVariables)this.one(TestLocalDynamicVariables.this.vars)).put("k", "v");
                ((DynamicVariables)this.one(TestLocalDynamicVariables.this.vars)).get("k");
                this.will(2.returnValue((Object)"v"));
            }
        });
        LocalDynamicVariables localDynamicVariables = new LocalDynamicVariables(this.vars);
        localDynamicVariables.put("k", "v");
        MatcherAssert.assertThat((Object)localDynamicVariables.get("k").toString(), (Matcher)CoreMatchers.is((Object)"v"));
    }

    @Test
    public void parameterOverrides() {
        LocalDynamicVariables localDynamicVariables = new LocalDynamicVariables(this.vars);
        localDynamicVariables.putParameter("k", "v");
        MatcherAssert.assertThat((Object)localDynamicVariables.get("k").toString(), (Matcher)CoreMatchers.is((Object)"v"));
    }

    @Test
    public void canChangeParameterLocally() {
        LocalDynamicVariables localDynamicVariables = new LocalDynamicVariables(this.vars);
        localDynamicVariables.putParameter("k", "v");
        localDynamicVariables.put("k", "VV");
        MatcherAssert.assertThat((Object)localDynamicVariables.get("k").toString(), (Matcher)CoreMatchers.is((Object)"VV"));
    }

    @Test
    public void addPropertiesFromFile() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DynamicVariables)this.one(TestLocalDynamicVariables.this.vars)).addFromPropertiesFile("k");
                this.will(3.returnValue((Object)true));
            }
        });
        LocalDynamicVariables localDynamicVariables = new LocalDynamicVariables(this.vars);
        MatcherAssert.assertThat((Object)localDynamicVariables.addFromPropertiesFile("k"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void addPropertiesFromUnicodeFile() throws IOException {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DynamicVariables)this.one(TestLocalDynamicVariables.this.vars)).addFromUnicodePropertyFile("k");
            }
        });
        LocalDynamicVariables localDynamicVariables = new LocalDynamicVariables(this.vars);
        localDynamicVariables.addFromUnicodePropertyFile("k");
    }
}

