/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.flow;

import fitlibrary.traverse.DomainAdapter;
import java.util.HashMap;
import java.util.Map;

public class SetUpTearDownReferenceCounter {
    private final Map<DomainAdapter, ReferenceCount> referenceCounts = new HashMap<DomainAdapter, ReferenceCount>();

    public void callSetUpOnNewReferences(Object sut, MethodCaller methodCaller) {
        Object object = sut;
        while (object instanceof DomainAdapter) {
            this.addReference((DomainAdapter)object, methodCaller);
            object = ((DomainAdapter)object).getSystemUnderTest();
        }
    }

    private void addReference(DomainAdapter object, MethodCaller methodCaller) {
        ReferenceCount referenceCount = this.referenceCounts.get(object);
        if (referenceCount == null) {
            methodCaller.setUp(object);
            referenceCount = new ReferenceCount(1);
            this.referenceCounts.put(object, referenceCount);
        } else {
            referenceCount.inc();
        }
    }

    public void callTearDownOnReferencesThatAreCountedDown(Object sut, MethodCaller methodCaller) {
        Object object = sut;
        while (object instanceof DomainAdapter) {
            this.removeReference((DomainAdapter)object, methodCaller);
            object = ((DomainAdapter)object).getSystemUnderTest();
        }
    }

    private void removeReference(DomainAdapter object, MethodCaller methodCaller) {
        ReferenceCount referenceCount = this.referenceCounts.get(object);
        if (referenceCount != null) {
            referenceCount.decrement();
            if (referenceCount.isZero()) {
                methodCaller.tearDown(object);
                this.referenceCounts.remove(object);
            }
        }
    }

    static class ReferenceCount {
        private int count = 0;

        public ReferenceCount(int count) {
            this.count = count;
        }

        public void inc() {
            ++this.count;
        }

        public void decrement() {
            --this.count;
        }

        public boolean isZero() {
            return this.count == 0;
        }
    }

    static interface MethodCaller {
        public void setUp(Object var1);

        public void tearDown(Object var1);
    }
}

