/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.flow;

import fitlibrary.SetUpFixture;
import fitlibrary.collection.CollectionSetUpTraverse;
import fitlibrary.flow.DoFlowDriverForTests;
import fitlibrary.matcher.TableBuilderForTests;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.traverse.Evaluator;
import fitlibrary.utility.CollectionUtility;
import java.util.List;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestDoFlowWithEvaluator {
    final Mockery context = new Mockery();
    final DoFlowDriverForTests doFlowDriver = new DoFlowDriverForTests(this.context);
    final Tables tables = (Tables)TableBuilderForTests.tables().with(TableBuilderForTests.table().with(TableBuilderForTests.row().with(TableBuilderForTests.cell(), TableBuilderForTests.cell()), TableBuilderForTests.row().with(TableBuilderForTests.cell(), TableBuilderForTests.cell()))).mock(this.context);

    @Before
    public void allows() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Table)this.allowing(TestDoFlowWithEvaluator.this.tables.at(0))).fromAt(0);
                this.will(1.returnValue(TestDoFlowWithEvaluator.this.tables.at(0)));
            }
        });
    }

    @Test
    public void runWithCollectionSetUpTraverse() {
        final Evaluator evaluator = (Evaluator)this.context.mock(Evaluator.class, "mockCollectionSetUpTraverse");
        CollectionSetUpTraverse collectionSetUpTraverse = new CollectionSetUpTraverse(){

            @Override
            public Object interpretAfterFirstRow(Table table, TestResults testResults) {
                return evaluator.interpretAfterFirstRow(table, testResults);
            }
        };
        this.verifyWithEvaluator(collectionSetUpTraverse, evaluator);
    }

    @Test
    public void runWithCollectionSetUpFixture() {
        final Evaluator evaluator = (Evaluator)this.context.mock(Evaluator.class, "mockSetUpFixture");
        SetUpFixture setUpFixture = new SetUpFixture(){

            @Override
            public Object interpretAfterFirstRow(Table table, TestResults testResults) {
                return evaluator.interpretAfterFirstRow(table, testResults);
            }
        };
        this.verifyWithEvaluator(setUpFixture, evaluator);
    }

    @Test
    public void runWithEvaluator() {
        final Evaluator evaluator = (Evaluator)this.context.mock(Evaluator.class, "mockEvaluator");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Evaluator)this.allowing(evaluator)).setRuntimeContext(TestDoFlowWithEvaluator.this.doFlowDriver.getRuntime());
                ((Evaluator)this.allowing(evaluator)).getSystemUnderTest();
                this.will(4.returnValue(null));
            }
        });
        this.verifyWithEvaluator(evaluator, evaluator);
    }

    private void verifyWithEvaluator(Evaluator evaluator, Evaluator evaluator2) {
        this.doFlowDriver.showTearDown = true;
        Table table = (Table)this.tables.at(0);
        this.doFlowDriver.startingOnTable(table);
        this.doFlowDriver.interpretingRowReturning((Row)table.at(0), evaluator);
        this.doFlowDriver.pushingObjectOnScopeStack(evaluator);
        this.doFlowDriver.callingSetUpOn(evaluator, (Row)table.at(0));
        this.doFlowDriver.interpretingEvaluator(evaluator2, table);
        this.doFlowDriver.poppingScopeStackAtEndOfLastTableGiving(this.list(evaluator));
        this.doFlowDriver.callingTearDownOn(evaluator, (Row)table.at(0));
        this.doFlowDriver.finishingTable(table);
        this.doFlowDriver.runStorytest(this.tables);
    }

    protected List<Object> list(Object ... objectArray) {
        return CollectionUtility.list(objectArray);
    }
}

