/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.log;

import fitlibrary.log.LogDelegationConfig;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class DelegatingLogger
extends Logger {
    private LogDelegationConfig config;

    protected DelegatingLogger(String name, LogDelegationConfig config) {
        super(name);
        this.config = config;
    }

    public void assertLog(boolean assertion, String msg) {
        super.assertLog(assertion, msg);
        if (this.config.isDelegating()) {
            this.delegate().assertLog(assertion, msg);
        }
    }

    public void debug(Object message) {
        super.debug(message);
        if (this.config.isDelegating()) {
            this.delegate().debug(message);
        }
    }

    public void debug(Object message, Throwable t) {
        super.debug(message, t);
        if (this.config.isDelegating()) {
            this.delegate().debug(message, t);
        }
    }

    public void error(Object message) {
        super.error(message);
        if (this.config.isDelegating()) {
            this.delegate().error(message);
        }
    }

    public void error(Object message, Throwable t) {
        super.error(message, t);
        if (this.config.isDelegating()) {
            this.delegate().error(message, t);
        }
    }

    public void fatal(Object message) {
        super.fatal(message);
        if (this.config.isDelegating()) {
            this.delegate().fatal(message);
        }
    }

    public void fatal(Object message, Throwable t) {
        super.fatal(message, t);
        if (this.config.isDelegating()) {
            this.delegate().fatal(message, t);
        }
    }

    public void info(Object message) {
        super.info(message);
        if (this.config.isDelegating()) {
            this.delegate().info(message);
        }
    }

    public void info(Object message, Throwable t) {
        super.info(message, t);
        if (this.config.isDelegating()) {
            this.delegate().info(message, t);
        }
    }

    public void log(Priority priority, Object message) {
        super.log(priority, message);
        if (this.config.isDelegating()) {
            this.delegate().log(priority, message);
        }
    }

    public void log(String callerFQCN, Priority level2, Object message, Throwable t) {
        super.log(callerFQCN, level2, message, t);
        if (this.config.isDelegating()) {
            this.delegate().log(callerFQCN, level2, message, t);
        }
    }

    public void trace(Object message) {
        super.trace(message);
        if (this.config.isDelegating()) {
            this.delegate().trace(message);
        }
    }

    public void trace(Object message, Throwable t) {
        super.trace(message, t);
        if (this.config.isDelegating()) {
            this.delegate().trace(message, t);
        }
    }

    public void warn(Object message) {
        super.warn(message);
        if (this.config.isDelegating()) {
            this.delegate().warn(message);
        }
    }

    public void warn(Object message, Throwable t) {
        super.warn(message, t);
        if (this.config.isDelegating()) {
            this.delegate().warn(message, t);
        }
    }

    private Logger delegate() {
        return this.config.delegate();
    }
}

