/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.matcher;

import fitlibrary.dynamicVariable.GlobalDynamicVariables;
import fitlibrary.dynamicVariable.VariableResolver;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.matcher.TableBuilderForTests;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.traverse.workflow.DoTraverse;
import java.util.Iterator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jmock.Mockery;
import org.jmock.api.ExpectationError;
import org.jmock.integration.junit4.JMock;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestTableBuilderForTests {
    final Mockery context = new Mockery();
    final VariableResolver resolver = new GlobalDynamicVariables();

    @Test
    public void emptyTablesHasSizeOf0() {
        Tables tables = (Tables)TableBuilderForTests.tables().mock(this.context);
        MatcherAssert.assertThat((Object)tables.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test(expected=FitLibraryException.class)
    public void emptyTablesHasNoLast() {
        Tables tables = (Tables)TableBuilderForTests.tables().mock(this.context);
        tables.last();
    }

    @Test(expected=ExpectationError.class)
    public void emptyTablesHasNoFirst() {
        Tables tables = (Tables)TableBuilderForTests.tables().mock(this.context);
        tables.at(0);
    }

    @Test
    public void emptyTablesHasEmptyIterator() {
        Tables tables = (Tables)TableBuilderForTests.tables().mock(this.context);
        MatcherAssert.assertThat((Object)tables.iterator().hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void cellHasTextBasedOnPath() {
        MatcherAssert.assertThat((Object)((Cell)TableBuilderForTests.cell().mock(this.context)).text(), (Matcher)CoreMatchers.is((Object)"Cell[0]"));
        MatcherAssert.assertThat((Object)((Cell)((Row)TableBuilderForTests.row().with(TableBuilderForTests.cell()).mock(this.context)).at(0)).text(), (Matcher)CoreMatchers.is((Object)"Row[0].Cell[0]"));
    }

    @Test
    public void cellHasNoEmbedded() {
        MatcherAssert.assertThat((Object)((Cell)TableBuilderForTests.cell().mock(this.context)).hasEmbeddedTables(this.resolver), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void cellHasSpecifiedText() {
        MatcherAssert.assertThat((Object)((Cell)TableBuilderForTests.cell("abc").mock(this.context)).text(), (Matcher)CoreMatchers.is((Object)"abc"));
    }

    @Test
    public void tableHasSpecifiedLeader() {
        MatcherAssert.assertThat((Object)((Table)TableBuilderForTests.table().withLeader("lead").mock(this.context)).getLeader(), (Matcher)CoreMatchers.is((Object)"lead"));
    }

    @Test
    public void rowOfOneHasSizeOf1() {
        TableBuilderForTests.RowBuilder rowBuilder = TableBuilderForTests.row().with(TableBuilderForTests.cell());
        Row row = (Row)rowBuilder.mock(this.context);
        MatcherAssert.assertThat((Object)row.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(row.last(), (Matcher)CoreMatchers.sameInstance(row.at(0)));
        Iterator iterator = row.iterator();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(iterator.next(), (Matcher)CoreMatchers.sameInstance(row.at(0)));
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)row.size(), (Matcher)CoreMatchers.is((Object)1));
        iterator = row.iterator();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(iterator.next(), (Matcher)CoreMatchers.sameInstance(row.at(0)));
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void rowOfTwoHasSizeOf2() {
        TableBuilderForTests.RowBuilder rowBuilder = TableBuilderForTests.row().with(TableBuilderForTests.cell(), TableBuilderForTests.cell());
        Row row = (Row)rowBuilder.mock(this.context);
        MatcherAssert.assertThat((Object)row.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(row.last(), (Matcher)CoreMatchers.is(row.at(1)));
        Iterator iterator = row.iterator();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(iterator.next(), (Matcher)CoreMatchers.sameInstance(row.at(0)));
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(iterator.next(), (Matcher)CoreMatchers.sameInstance(row.at(1)));
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat(row.at(0), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance(row.at(1))));
    }

    @Test
    public void largeTablesHasAllTheRightValues() {
        TableBuilderForTests.TablesBuilder tablesBuilder = TableBuilderForTests.tables().with(TableBuilderForTests.table().with(TableBuilderForTests.row().with(TableBuilderForTests.cell(), TableBuilderForTests.cell()), TableBuilderForTests.row().with(TableBuilderForTests.cell().with(TableBuilderForTests.table().with(TableBuilderForTests.row().with(TableBuilderForTests.cell()), TableBuilderForTests.row().with(TableBuilderForTests.cell()), TableBuilderForTests.row().with(TableBuilderForTests.cell()))))));
        Tables tables = (Tables)tablesBuilder.mock(this.context);
        MatcherAssert.assertThat((Object)tables.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(tables.last(), (Matcher)CoreMatchers.sameInstance(tables.at(0)));
        Iterator iterator = tables.iterator();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(iterator.next(), (Matcher)CoreMatchers.sameInstance(tables.at(0)));
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)CoreMatchers.is((Object)false));
        Table table = (Table)tables.at(0);
        MatcherAssert.assertThat((Object)table.size(), (Matcher)CoreMatchers.is((Object)2));
        Row row = (Row)table.at(0);
        MatcherAssert.assertThat((Object)row.size(), (Matcher)CoreMatchers.is((Object)2));
        Cell cell = (Cell)row.at(0);
        MatcherAssert.assertThat((Object)cell.text(), (Matcher)CoreMatchers.is((Object)"Tables[0].Table[0].Row[0].Cell[0]"));
        MatcherAssert.assertThat((Object)cell.text(new DoTraverse()), (Matcher)CoreMatchers.is((Object)"Tables[0].Table[0].Row[0].Cell[0]"));
        Row row2 = (Row)table.at(1);
        MatcherAssert.assertThat((Object)row2.size(), (Matcher)CoreMatchers.is((Object)1));
        Cell cell2 = (Cell)row2.at(0);
        Iterator iterator2 = cell2.iterator();
        MatcherAssert.assertThat((Object)iterator2.hasNext(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(iterator2.next(), (Matcher)CoreMatchers.sameInstance(cell2.at(0)));
        MatcherAssert.assertThat((Object)iterator2.hasNext(), (Matcher)CoreMatchers.is((Object)false));
        Table table2 = (Table)cell2.at(0);
        MatcherAssert.assertThat((Object)table2.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)((Row)table2.at(0)).size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Cell)((Row)table2.at(0)).at(0)).text(), (Matcher)CoreMatchers.is((Object)"Tables[0].Table[0].Row[1].Cell[0].Table[0].Row[0].Cell[0]"));
    }
}

