/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.object;

import fitlibrary.closure.ICalledMethodTarget;
import fitlibrary.exception.IgnoredException;
import fitlibrary.global.PlugBoard;
import fitlibrary.object.DomainTraverser;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.traverse.TableEvaluator;
import fitlibrary.traverse.Traverse;
import fitlibrary.typed.TypedObject;

public class DomainInjectionTraverse
extends Traverse
implements TableEvaluator {
    private DomainTraverser domainTraverser = null;

    public DomainInjectionTraverse() {
    }

    public DomainInjectionTraverse(DomainTraverser domainTraverser) {
        this.domainTraverser = domainTraverser;
    }

    public void setDomainTraverse(DomainTraverser domainTraverser) {
        this.domainTraverser = domainTraverser;
    }

    @Override
    public void runTable(Table table, TestResults testResults) {
        if (this.switchOnActions(table)) {
            this.domainTraverser.setCurrentAction();
            return;
        }
        if (this.switchOnChecks(table)) {
            this.domainTraverser.setCurrentCheck();
            return;
        }
        try {
            for (int rowNo = 0; rowNo < table.size(); ++rowNo) {
                this.processRow((Row)table.at(rowNo), testResults);
            }
        }
        catch (IgnoredException e) {
        }
        catch (Exception e) {
            table.error(testResults, (Throwable)e);
        }
    }

    private boolean switchOnActions(Table table) {
        return this.domainTraverser != null && table.size() == 1 && ((Row)table.at(0)).size() == 1 && ((Cell)((Row)table.at(0)).at(0)).matchesTextInLowerCase("actions", this);
    }

    private boolean switchOnChecks(Table table) {
        return this.domainTraverser != null && table.size() == 1 && ((Row)table.at(0)).size() == 1 && ((Cell)((Row)table.at(0)).at(0)).matchesTextInLowerCase("checks", this);
    }

    public void processRow(Row row, TestResults testResults) {
        for (int i = 0; i < row.size(); i += 2) {
            Cell cell = (Cell)row.at(i);
            try {
                ICalledMethodTarget target = PlugBoard.lookupTarget.findSetterOnSut(cell.text(this), this);
                Cell nextCell = (Cell)row.at(i + 1);
                try {
                    target.invoke(nextCell, testResults);
                }
                catch (IgnoredException e) {
                }
                catch (Exception e) {
                    nextCell.error(testResults, e);
                }
                continue;
            }
            catch (Exception e) {
                cell.error(testResults, e);
            }
        }
    }

    @Override
    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        table.error(testResults, (Throwable)new RuntimeException("Don't expect to have this called!"));
        return null;
    }

    @Override
    public void addNamedObject(String text, TypedObject typedObject, Row row, TestResults testResults) {
    }

    @Override
    public void select(String name) {
    }

    @Override
    public void runInnerTables(Tables definedActionBody, TestResults testResults) {
    }
}

