/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.parser;

import fitlibrary.closure.Closure;
import fitlibrary.exception.classes.NoNullaryConstructor;
import fitlibrary.exception.parse.BadNumberException;
import fitlibrary.global.PlugBoard;
import fitlibrary.object.DomainObjectCheckTraverse;
import fitlibrary.object.DomainObjectSetUpTraverse;
import fitlibrary.parser.DelegateParser;
import fitlibrary.parser.Parser;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Cell;
import fitlibrary.table.Table;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.Typed;
import fitlibrary.typed.TypedObject;

public class DelegatingParser
implements Parser {
    protected final DelegateParser delegateParser;
    protected final Evaluator evaluator;
    protected final Typed typed;

    public DelegatingParser(DelegateParser delegateParser, Evaluator evaluator, Typed typed) {
        this.delegateParser = delegateParser;
        this.evaluator = evaluator;
        this.typed = typed;
    }

    @Override
    public TypedObject parseTyped(Cell cell, TestResults testResults) throws Exception {
        return this.typed.typedObject(this.parse(cell, testResults));
    }

    private Object parse(Cell cell, TestResults testResults) throws Exception {
        if (cell.hasEmbeddedTables(this.evaluator)) {
            return this.parseTable(cell.getEmbeddedTable(), testResults);
        }
        try {
            return this.delegateParser.parse(cell.text(this.evaluator), this.typed);
        }
        catch (NumberFormatException e) {
            throw new BadNumberException();
        }
    }

    protected Object parseTable(Table embeddedTable, TestResults testResults) throws Exception {
        Object newInstance = null;
        try {
            newInstance = this.typed.newInstance();
        }
        catch (Exception e) {
            Closure fixturingMethod = PlugBoard.lookupTarget.findNewInstancePluginMethod(this.evaluator);
            if (fixturingMethod == null) {
                throw new NoNullaryConstructor(this.typed.asClass());
            }
            newInstance = fixturingMethod.invoke(new Object[]{this.typed.asClass()});
        }
        DomainObjectSetUpTraverse setUp = new DomainObjectSetUpTraverse(newInstance);
        setUp.setRuntimeContext(this.evaluator.getRuntimeContext());
        setUp.callStartCreatingObjectMethod(newInstance);
        setUp.interpretInnerTableWithInScope(embeddedTable, this.evaluator.getRuntimeContext(), testResults);
        setUp.callEndCreatingObjectMethod(newInstance);
        return newInstance;
    }

    @Override
    public boolean matches(Cell cell, Object result, TestResults testResults) throws Exception {
        if (cell.hasEmbeddedTables(this.evaluator)) {
            return this.matchesTable(cell.getEmbeddedTable(), result, testResults);
        }
        return this.delegateParser.matches(this.parse(cell, testResults), result);
    }

    protected boolean matchesTable(Table table, Object result, TestResults testResults) {
        DomainObjectCheckTraverse traverse = new DomainObjectCheckTraverse(result, this.typed);
        return traverse.doesInnerTablePass(table, this.evaluator.getRuntimeContext(), testResults);
    }

    @Override
    public String show(Object result) throws Exception {
        return this.delegateParser.show(result);
    }

    public String toString() {
        return this.delegateParser.toString();
    }

    @Override
    public Evaluator traverse(TypedObject object) {
        throw new RuntimeException("No Traverse available");
    }
}

