/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.parser.graphic;

import fitlibrary.parser.graphic.DotGraphic;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ObjectDotGraphic
extends DotGraphic {
    private int nodeNo = 0;
    private String[] exclusions = new String[]{"sun.", "com.sun.", "org.omg.", "javax.", "sunw.", "java.", "org.w3c.dom.", "org.xml.sax.", "net.jini."};
    private HashMap<Object, String> visited = new HashMap();
    private List<Object> queue = new LinkedList<Object>();
    private int nodesToProcess = 50;

    public ObjectDotGraphic(Object object) {
        super("");
        String firstNodeID = "n0";
        this.dot = "digraph G {\n" + this.visit(object, firstNodeID) + this.buildGraph() + "}\n";
    }

    private String buildGraph() {
        String result = "";
        while (!this.queue.isEmpty() && --this.nodesToProcess > 0) {
            Object object = this.queue.remove(0);
            String objectID = this.visited.get(object);
            Class<?> type = object.getClass();
            if (object instanceof Set) {
                result = result + this.buildSetGraph(objectID, (Set)object);
                continue;
            }
            if (object instanceof Map) {
                result = result + this.buildSetGraph(objectID, ((Map)object).entrySet());
                continue;
            }
            if (object instanceof Collection) {
                result = result + this.buildCollectionGraph(objectID, (Collection)object);
                continue;
            }
            if (object instanceof Object[]) {
                result = result + this.buildCollectionGraph(objectID, Arrays.asList((Object[])object));
                continue;
            }
            result = result + this.buildObjectGraph(objectID, object, this.getAllFields(type));
        }
        return result;
    }

    private Object[] getAllFields(Class<?> type) {
        LinkedList<Field> fields = new LinkedList<Field>();
        this.getAllFields(type, fields);
        return fields.toArray();
    }

    private void getAllFields(Class<?> type, List<Field> list) {
        list.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type != Object.class) {
            this.getAllFields(type.getSuperclass(), list);
        }
    }

    private String buildObjectGraph(String objectID, Object object, Object[] fields) {
        String result = "";
        for (int i = 0; i < fields.length; ++i) {
            Field field = (Field)fields[i];
            try {
                String name = field.getName();
                Object value = field.get(object);
                result = result + this.makeArc(objectID, value, name);
                continue;
            }
            catch (IllegalAccessException e) {
                result = result + this.accessThroughProperty(field, objectID, object);
            }
        }
        return result;
    }

    private String firstUpper(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private String accessThroughProperty(Field field, String objectID, Object object) {
        String name = this.firstUpper(field.getName());
        String methodName = "get" + name;
        if (field.getType().equals(Boolean.class)) {
            methodName = "is" + name;
        }
        try {
            Method method = object.getClass().getMethod(methodName, new Class[0]);
            Object value = method.invoke(object, new Object[0]);
            return this.makeArc(objectID, value, name);
        }
        catch (Exception e) {
            return "";
        }
    }

    private String makeArc(String objectID, Object value, String label) {
        String result = "";
        String valueID = this.visited.get(value);
        if (valueID == null) {
            ++this.nodeNo;
            valueID = "n" + this.nodeNo;
            result = result + this.visit(value, valueID);
        }
        result = result + objectID + " -> " + valueID + " [label=\"" + label + "\"];\n";
        return result;
    }

    private String visit(Object object, String nodeID) {
        this.visited.put(object, nodeID);
        if (this.excluded(object)) {
            return nodeID + " [label = \"" + object.toString() + "\"];\n";
        }
        this.queue.add(object);
        Class<?> type = object.getClass();
        if (type.isArray()) {
            return nodeID + " [label = \"" + type.getComponentType().getName() + "[]\"];\n";
        }
        if (this.collectionSetOrMap(object)) {
            return nodeID + " [shape=box, label = \"" + type.getName() + "\"];\n";
        }
        return nodeID + " [label = \"" + type.getName() + "\"];\n";
    }

    private String buildCollectionGraph(String objectID, Collection<?> collection) {
        String result = "";
        int count = 0;
        for (Object value : collection) {
            result = result + this.makeArc(objectID, value, "[" + count + "]");
        }
        return result;
    }

    private String buildSetGraph(String objectID, Set<Object> set) {
        String result = "";
        for (Object value : set) {
            result = result + this.makeArc(objectID, value, "");
        }
        return result;
    }

    private boolean excluded(Object object) {
        if (this.collectionSetOrMap(object)) {
            return false;
        }
        String name = object.getClass().getName();
        for (int i = 0; i < this.exclusions.length; ++i) {
            if (!name.startsWith(this.exclusions[i])) continue;
            return true;
        }
        return false;
    }

    private boolean collectionSetOrMap(Object object) {
        return object instanceof Collection || object instanceof Set || object instanceof Map;
    }

    public Object getDot() {
        return this.dot;
    }
}

