/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spec.matcher;

import fitlibrary.spec.PipeLine;
import fitlibrary.spec.matcher.FitLabelMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestFitLabelMatcher {
    final Mockery context = new Mockery();
    final PipeLine pipeline = (PipeLine)this.context.mock(PipeLine.class);
    final FitLabelMatcher matcher = new FitLabelMatcher(this.pipeline);

    @Test
    public void noAffectWhenNoFitLabel() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((PipeLine)this.oneOf(TestFitLabelMatcher.this.pipeline)).match("ab", "ab");
                this.will(1.returnValue((Object)true));
            }
        });
        this.matcher.match("ab", "ab");
    }

    @Test
    public void failsWhenFitLabelOnlyInActual() {
        MatcherAssert.assertThat((Object)this.matcher.match("ab<span class=\"fit_label\">ABC</span>cd", "abcd"), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void failsWhenFitLabelOnlyInExpected() {
        MatcherAssert.assertThat((Object)this.matcher.match("abcd", "ab<span class=\"fit_label\">ABC</span>cd"), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void whenFitLabelSame() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((PipeLine)this.oneOf(TestFitLabelMatcher.this.pipeline)).match("ab", "ab");
                this.will(2.returnValue((Object)true));
                ((PipeLine)this.oneOf(TestFitLabelMatcher.this.pipeline)).match("cd", "cd");
                this.will(2.returnValue((Object)true));
            }
        });
        MatcherAssert.assertThat((Object)this.matcher.match("ab<span class=\"fit_label\">ABC</span>cd", "ab<span class=\"fit_label\">ABC</span>cd"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void whenActualFitLabelStartsTheSame() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((PipeLine)this.oneOf(TestFitLabelMatcher.this.pipeline)).match("ab", "ab");
                this.will(3.returnValue((Object)true));
                ((PipeLine)this.oneOf(TestFitLabelMatcher.this.pipeline)).match("cd", "cd");
                this.will(3.returnValue((Object)true));
            }
        });
        MatcherAssert.assertThat((Object)this.matcher.match("ab<span class=\"fit_label\">ABC and more</span>cd", "ab<span class=\"fit_label\">ABC</span>cd"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void whenActualFitLabelDoesNotStartTheSame() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((PipeLine)this.oneOf(TestFitLabelMatcher.this.pipeline)).match("ab", "ab");
                this.will(4.returnValue((Object)true));
            }
        });
        MatcherAssert.assertThat((Object)this.matcher.match("ab<span class=\"fit_label\">DIFFERENT</span>cd", "ab<span class=\"fit_label\">ABC</span>cd"), (Matcher)CoreMatchers.is((Object)false));
    }
}

