/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.special;

import fitlibrary.closure.ICalledMethodTarget;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.exception.IgnoredException;
import fitlibrary.parser.Parser;
import fitlibrary.runResults.TestResults;
import fitlibrary.runtime.RuntimeContext;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.special.DoAction;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.tableProxy.CellProxy;

public class DoActionInContext
implements DoAction {
    private final ICalledMethodTarget target;
    protected final Row row;
    private final int innerFrom;
    private final int from;
    private final int to;
    private final boolean sequencing;
    protected final RuntimeContextInternal runtime;

    public DoActionInContext(ICalledMethodTarget target, Row row, int innerFrom, int innerUpTo, boolean sequencing, RuntimeContextInternal runtime) {
        this.target = target;
        this.row = row;
        this.innerFrom = innerFrom;
        this.sequencing = sequencing;
        this.runtime = runtime;
        if (innerFrom == 0) {
            this.from = innerUpTo;
            this.to = row.size();
        } else {
            this.from = 0;
            this.to = innerFrom;
        }
    }

    @Override
    public Object run() throws Exception {
        return this.run(true);
    }

    private Object run(boolean markErrors) throws Exception {
        Parser[] parameterParsers = this.target.getParameterParsers();
        Object[] args = new Object[parameterParsers.length];
        TestResults testResults = this.runtime.getTestResults();
        for (int i = 0; i < parameterParsers.length; ++i) {
            try {
                args[i] = parameterParsers[i].parseTyped(this.offsetArgumentCell(i), testResults).getSubject();
                continue;
            }
            catch (Exception e) {
                if (markErrors) {
                    this.offsetArgumentCell(i).error(testResults, e);
                }
                throw new IgnoredException(e);
            }
        }
        return this.target.invoke(args);
    }

    @Override
    public Object runWithNoColouring() throws Exception {
        return this.run(false);
    }

    private Cell offsetArgumentCell(int i) {
        if (this.sequencing) {
            return (Cell)this.row.at(this.innerFrom + i + 1);
        }
        return (Cell)this.row.at(this.innerFrom + i * 2 + 1);
    }

    @Override
    public RuntimeContext getRuntime() {
        return this.runtime;
    }

    @Override
    public CellProxy cellAt(int i) {
        if (i < 0 || i >= this.to - this.from) {
            throw new FitLibraryException("No special cell at " + i);
        }
        final Cell cell = (Cell)this.row.at(this.from + i);
        return new CellProxy(){

            @Override
            public void pass() {
                cell.pass(DoActionInContext.this.runtime.getTestResults());
            }

            @Override
            public void pass(String msg) {
                cell.pass(DoActionInContext.this.runtime.getTestResults(), msg);
            }

            @Override
            public void fail() {
                cell.fail(DoActionInContext.this.runtime.getTestResults());
            }

            @Override
            public void fail(String msg) {
                cell.fail(DoActionInContext.this.runtime.getTestResults(), msg, DoActionInContext.this.runtime.getResolver());
            }

            @Override
            public void failHtml(String msg) {
                cell.failHtml(DoActionInContext.this.runtime.getTestResults(), msg);
            }

            @Override
            public void error(String msg) {
                cell.error(DoActionInContext.this.runtime.getTestResults(), msg);
            }

            @Override
            public void error(Throwable e) {
                cell.error(DoActionInContext.this.runtime.getTestResults(), e);
            }

            @Override
            public void error() {
                cell.error(DoActionInContext.this.runtime.getTestResults());
            }
        };
    }

    @Override
    public void showResult(Object result) throws Exception {
        this.runtime.show(this.target.getResultString(result));
    }

    public String toString() {
        return this.target.toString();
    }

    @Override
    public void show(String htmlString) {
        this.runtime.show(htmlString);
    }

    @Override
    public void showAfter(Object result) throws Exception {
        this.runtime.showAsAfterTable("Logs", this.target.getResultString(result));
    }

    @Override
    public void showAfterAs(String title, Object result) throws Exception {
        this.runtime.showAsAfterTable(title, this.target.getResultString(result));
    }
}

