/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.suite;

import fit.FitServerBridge;
import fit.exception.FitParseException;
import fitlibrary.log.ConfigureLoggingThroughFiles;
import fitlibrary.log.FitLibraryLogger;
import fitlibrary.runResults.TableListener;
import fitlibrary.runResults.TestResults;
import fitlibrary.runResults.TestResultsOnCounts;
import fitlibrary.suite.BatchFitLibrary;
import fitlibrary.table.TableFactory;
import fitlibrary.table.Tables;
import java.util.Date;
import org.apache.log4j.Logger;

public class FitLibraryServer
extends FitServerBridge {
    static Logger logger = FitLibraryLogger.getLogger(FitLibraryServer.class);
    private BatchFitLibrary batching = new BatchFitLibrary();

    @Override
    public TestResults doTables(String html) {
        try {
            return this.doTables(TableFactory.tables(html));
        }
        catch (FitParseException e) {
            e.printStackTrace();
            return new TestResultsOnCounts();
        }
    }

    public TestResults doTables(Tables theTables) {
        TableListener tableListener = new TableListener(this.reportListener);
        this.batching.doTables(theTables, tableListener);
        return tableListener.getTestResults();
    }

    @Override
    public void exit() throws Exception {
        this.batching.exit();
        super.exit();
    }

    @Override
    protected void usage() {
        logger.trace((Object)"usage: java fitlibrary.suite.FitLibraryServer [-v] host port socketTicket");
        System.exit(-1);
    }

    public static void main(String[] args) {
        ConfigureLoggingThroughFiles.configure();
        FitLibraryServer fitServer = new FitLibraryServer();
        try {
            logger.trace((Object)new Date());
            fitServer.run(args);
            logger.trace((Object)("Exit: " + fitServer.exitCode()));
            if (fitServer.isExit()) {
                System.exit(fitServer.exitCode());
            }
        }
        catch (Exception e) {
            fitServer.printExceptionDetails(e);
        }
    }
}

