/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.suite;

import fit.FitServerBridge;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Table;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;

public class Reporter
implements Runnable {
    private final BlockingQueue<ReportAction> reportQueue;
    private final FitServerBridge fitServerBridge;
    private final CountDownLatch endGate;
    private final TestResults testResults;

    public Reporter(BlockingQueue<ReportAction> reportQueue, FitServerBridge fitServerBridge, CountDownLatch endGate, TestResults testResults) {
        this.reportQueue = reportQueue;
        this.fitServerBridge = fitServerBridge;
        this.endGate = endGate;
        this.testResults = testResults;
    }

    @Override
    public void run() {
        try {
            ReportAction action;
            do {
                action = this.reportQueue.take();
                action.run(this.fitServerBridge, this.testResults);
            } while (!action.isDone());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.endGate.countDown();
    }

    public static class ReportFinished
    implements ReportAction {
        @Override
        public void run(FitServerBridge fitLibraryServer, TestResults testResults) {
            fitLibraryServer.sendTestResults(testResults);
        }

        @Override
        public boolean isDone() {
            return true;
        }
    }

    public static class TableReport
    implements ReportAction {
        private final Table table;

        public TableReport(Table table) {
            this.table = table;
        }

        @Override
        public void run(FitServerBridge fitLibraryServer, TestResults testResults) {
            fitLibraryServer.sendTableReport(this.table);
        }

        @Override
        public boolean isDone() {
            return false;
        }
    }

    public static interface ReportAction {
        public void run(FitServerBridge var1, TestResults var2);

        public boolean isDone();
    }
}

