/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.table;

import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.TableFactory;
import fitlibrary.table.Tables;

public class TableConversion {
    public static Tables convert(Tables tables) {
        Tables result = TableFactory.tables();
        for (Table table : tables) {
            result.add(TableConversion.convert(table));
        }
        return result;
    }

    public static Table convert(Table table) {
        Table result = TableFactory.table();
        result.setLeader(table.getLeader());
        result.setTrailer(table.getTrailer());
        result.setTagLine(table.getTagLine());
        for (Row row : table) {
            result.add(TableConversion.convert(row));
        }
        return result;
    }

    public static Row convert(Row row) {
        Row result = TableFactory.row();
        result.setLeader(row.getLeader());
        result.setTrailer(row.getTrailer());
        result.setTagLine(row.getTagLine());
        for (Cell cell : row) {
            result.add(TableConversion.convert(cell));
        }
        return result;
    }

    public static Cell convert(Cell cell) {
        Cell result = TableFactory.cell(cell.fullText());
        result.setLeader(cell.getLeader());
        result.setTrailer(cell.getTrailer());
        result.setTagLine(cell.getTagLine());
        for (Table table : cell) {
            result.add(TableConversion.convert(table));
        }
        return result;
    }
}

