/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.table;

import fit.Parse;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.TableElement;
import fitlibrary.table.TablesOnList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class TableElementOnList<From extends TableElement, To extends TableElement> {
    public static final String PASS = "class=\"pass\"";
    public static final String FAIL = "class=\"fail\"";
    public static final String IGNORE = "class=\"ignore\"";
    public static final String ERROR = "class=\"error\"";
    public static final String SHOWN = "bgcolor=#C0C0FF";
    public static final String CALLS = "bgcolor=#DADAFF";
    private final String tag;
    protected String tagAnnotation = "";
    private String leader = "";
    private String trailer = "";
    private List<To> elements = new ArrayList<To>();

    public boolean atExists(int i) {
        return i >= 0 && i < this.size();
    }

    public int size() {
        return this.elements.size();
    }

    public To last() {
        return this.at(this.size() - 1);
    }

    public To at(int i) {
        return (To)((TableElement)this.elements.get(i));
    }

    public From add(To to) {
        this.elements.add(to);
        return (From)((TableElement)((Object)this));
    }

    public void add(int i, To to) {
        this.elements.add(i, to);
    }

    public void removeElementAt(int i) {
        this.elements.remove(i);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator<To> iterator() {
        return this.iterableFrom(0).iterator();
    }

    public Iterable<To> iterableFrom(int start) {
        ArrayList<To> list = new ArrayList<To>();
        for (int i = start; i < this.size(); ++i) {
            list.add(this.at(i));
        }
        return list;
    }

    public From fromAt(int start) {
        if (start == 0) {
            return (From)((TableElement)((Object)this));
        }
        return this.fromTo(start, this.size());
    }

    public From fromTo(int from, int upto) {
        From result = this.newObject();
        for (int i = from; i < upto; ++i) {
            result.add(this.at(i));
        }
        return result;
    }

    public void clear() {
        this.elements.clear();
    }

    public TableElementOnList(String tag) {
        this.tag = tag;
    }

    public String getLeader() {
        return this.leader;
    }

    public String getTrailer() {
        return this.trailer;
    }

    protected void addToTrailer(String s) {
        this.trailer = s + this.trailer;
    }

    protected void addToStartOfLeader(String s) {
        this.leader = s + this.leader;
    }

    public void setLeader(String leader) {
        this.leader = leader;
    }

    public void setTrailer(String trailer) {
        this.trailer = trailer;
    }

    public void pass(TestResults testResults) {
        this.addToTag(PASS);
        testResults.pass();
    }

    public void fail(TestResults testResults) {
        if (!this.hadError()) {
            this.addToTag(FAIL);
            testResults.fail();
        }
    }

    public void passOrFail(TestResults testResults, boolean right) {
        if (right) {
            this.pass(testResults);
        } else {
            this.fail(testResults);
        }
    }

    public void error(TestResults testResults, Throwable e) {
        this.at(0).error(testResults, e);
    }

    public void shown() {
        this.addToTag(SHOWN);
    }

    public void calls() {
        this.addToTag(CALLS);
    }

    public static String label(String string) {
        return " <span class=\"fit_label\">" + string + "</span>";
    }

    public boolean didPass() {
        return this.tagContains(PASS);
    }

    public boolean didFail() {
        return this.tagContains(FAIL);
    }

    public boolean wasIgnored() {
        return this.tagContains(IGNORE);
    }

    public boolean hadError() {
        return this.tagContains(ERROR);
    }

    private boolean tagContains(String label) {
        return this.tagAnnotation.indexOf(label) >= 0;
    }

    public String getTagLine() {
        return this.tagAnnotation;
    }

    public void setTagLine(String tagLine) {
        this.tagAnnotation = tagLine;
    }

    public void addToTag(String report) {
        if (this.tag.isEmpty()) {
            this.at(0).addToTag(report.trim());
        }
        this.tagAnnotation = this.tagAnnotation.isEmpty() ? this.tagAnnotation + report.trim() : this.tagAnnotation + " " + report.trim();
    }

    public Parse parse() {
        throw new RuntimeException("Unable to provide a Parse.");
    }

    public String getType() {
        return this.tag;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toHtml(builder);
        return builder.toString();
    }

    public void toHtml(StringBuilder builder) {
        boolean everything;
        boolean bl = everything = this.getClass() != TablesOnList.class;
        if (everything) {
            builder.append(this.getLeader());
            builder.append("<").append(this.tag);
            if (!this.getTagLine().isEmpty()) {
                builder.append(" ").append(this.getTagLine());
            }
            builder.append(">");
        }
        for (TableElement to : this.elements) {
            to.toHtml(builder);
        }
        if (everything) {
            this.appendBody(builder);
            if (!this.tag.isEmpty()) {
                builder.append("</").append(this.tag).append(">");
            }
            builder.append(this.getTrailer());
        }
    }

    protected void appendBody(StringBuilder builder) {
    }

    protected abstract From newObject();
}

