/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.tableOnParse;

import fit.Fixture;
import fit.Parse;
import fitlibrary.dynamicVariable.VariableResolver;
import fitlibrary.exception.table.SingleNestedTableExpected;
import fitlibrary.global.PlugBoard;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Cell;
import fitlibrary.table.Table;
import fitlibrary.table.TableFactory;
import fitlibrary.table.Tables;
import fitlibrary.tableOnParse.TablesOnParse;
import fitlibrary.utility.HtmlUtils;
import fitlibrary.utility.Pair;
import fitlibrary.utility.ParseUtility;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CellOnParse
extends TablesOnParse
implements Cell {
    static final Pattern COLSPAN_PATTERN = Pattern.compile(".*\\b(colspan\\s*=\\s*\"?\\s*(\\d+)\\s*\"?).*");
    private boolean cellIsInHiddenRow = false;

    public CellOnParse(Parse parse) {
        super(parse);
    }

    public CellOnParse(String cellText) {
        this(new Parse("td", cellText, null, null));
    }

    public CellOnParse(Cell cell) {
        this("");
        if (!cell.getEmbeddedTables().isEmpty()) {
            this.setInnerTables(cell.getEmbeddedTables());
        } else {
            this.setText(cell.fullText());
        }
    }

    public CellOnParse(Tables innerTables) {
        this(new Parse("td", "", innerTables.parse(), null));
    }

    @Override
    public void setText(String text) {
        this.parse.body = text;
    }

    @Override
    public String text(VariableResolver resolver) {
        if (this.parse.body == null) {
            return "";
        }
        Pair<String, Tables> resolve = resolver.resolve(this.parse.body);
        if (!this.parse.body.equals(resolve.first)) {
            this.parse.body = (String)resolve.first;
        }
        this.addTables((Tables)resolve.second);
        return this.text();
    }

    @Override
    public String text() {
        if (this.parse.body == null) {
            return "";
        }
        return this.parse.text();
    }

    @Override
    public boolean unresolved(VariableResolver resolver) {
        return this.text().startsWith("@{") && this.text().indexOf("}") == this.text().length() - 1 && this.text().equals(this.text(resolver));
    }

    @Override
    public String textLower(VariableResolver resolver) {
        return this.text(resolver).toLowerCase();
    }

    @Override
    public boolean matchesTextInLowerCase(String s, VariableResolver resolver) {
        return this.text(resolver).toLowerCase().equals(s.toLowerCase());
    }

    @Override
    public boolean isBlank(VariableResolver resolver) {
        return this.text(resolver).equals("");
    }

    @Override
    public CellOnParse deepCopy() {
        return new CellOnParse(ParseUtility.copyParse(this.parse));
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof CellOnParse)) {
            return false;
        }
        CellOnParse other = (CellOnParse)object;
        return this.parse.body.equals(other.parse.body);
    }

    @Override
    public int hashCode() {
        return this.parse.body.hashCode();
    }

    @Override
    public void expectedElementMissing(TestResults testResults) {
        this.fail(testResults);
        this.addToBody(CellOnParse.label("missing"));
    }

    @Override
    public void actualElementMissing(TestResults testResults) {
        this.fail(testResults);
        this.addToBody(CellOnParse.label("surplus"));
    }

    @Override
    public void unexpected(TestResults testResults, String s) {
        this.fail(testResults);
        this.addToBody(CellOnParse.label("unexpected " + s));
    }

    @Override
    public void actualElementMissing(TestResults testResults, String value) {
        this.fail(testResults);
        this.parse.body = Fixture.gray(Fixture.escape(value.toString()));
        this.addToBody(CellOnParse.label("surplus"));
    }

    @Override
    public void pass(TestResults testResults) {
        if (this.cellIsInHiddenRow) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        super.pass(testResults);
    }

    @Override
    public void pass(TestResults testResults, String msg) {
        if (this.cellIsInHiddenRow) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        super.pass(testResults);
        this.addToBody("<hr>" + Fixture.escape(msg) + CellOnParse.label("actual"));
    }

    @Override
    public void fail(TestResults testResults) {
        if (this.cellIsInHiddenRow) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        super.fail(testResults);
    }

    @Override
    public void fail(TestResults testResults, String msg, VariableResolver resolver) {
        if ("".equals(this.parse.body) && !this.hasEmbeddedTables(resolver)) {
            this.failHtml(testResults, msg);
            return;
        }
        this.fail(testResults);
        String resolved = "";
        if (!this.text().equals(this.text(resolver))) {
            resolved = " = " + this.text(resolver);
        }
        this.addToBody(resolved + CellOnParse.label("expected") + "<hr>" + Fixture.escape(msg) + CellOnParse.label("actual"));
    }

    @Override
    public void failWithStringEquals(TestResults testResults, String actual, VariableResolver resolver) {
        if ("".equals(this.parse.body) && !this.hasEmbeddedTables(resolver)) {
            this.failHtml(testResults, actual);
            return;
        }
        this.fail(testResults);
        String resolved = "";
        if (!this.text().equals(this.text(resolver))) {
            resolved = " = " + this.text(resolver);
        }
        this.addToBody(resolved + CellOnParse.label("expected") + "<hr>" + Fixture.escape(actual) + CellOnParse.label("actual") + CellOnParse.differences(Fixture.escape(this.text(resolver)), Fixture.escape(actual)));
    }

    public static String differences(String actual, String expected) {
        return PlugBoard.stringDifferencing.differences(actual, expected);
    }

    @Override
    public void failHtml(TestResults testResults, String msg) {
        this.fail(testResults);
        this.addToBody(msg);
    }

    @Override
    public void error(TestResults testResults, Throwable e) {
        if (this.cellIsInHiddenRow) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        this.addToBody(PlugBoard.exceptionHandling.exceptionMessage(e));
        this.parse.addToTag(" class=\"error\"");
        testResults.exception();
    }

    @Override
    public void error(TestResults testResults, String msg) {
        if (this.cellIsInHiddenRow) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        this.addToBody("<hr/>" + Fixture.label(msg));
        this.parse.addToTag(" class=\"error\"");
        testResults.exception();
    }

    @Override
    public void error(TestResults testResults) {
        if (this.cellIsInHiddenRow) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        this.parse.addToTag(" class=\"error\"");
        testResults.exception();
    }

    @Override
    public void ignore(TestResults testResults) {
        if (this.parse.tag.contains(" bgcolor=#DADAFF")) {
            return;
        }
        if (this.cellIsInHiddenRow) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        this.ensureBodyNotNull();
        if (this.parse.tag.indexOf("class") >= 0) {
            throw new RuntimeException("Duplicate cell class in tag. Tag is already: " + this.parse.tag.substring(1, this.parse.tag.length() - 2));
        }
        this.parse.addToTag(" class=\"ignore\"");
        testResults.ignore();
    }

    @Override
    public void exceptionExpected(boolean exceptionExpected, Exception e, TestResults testResults) {
        if (exceptionExpected) {
            this.pass(testResults);
        } else {
            this.error(testResults, e);
        }
    }

    @Override
    public Table getEmbeddedTable() {
        TablesOnParse tables = this.getEmbeddedTables();
        if (tables.size() != 1) {
            throw new SingleNestedTableExpected();
        }
        return tables.at(0);
    }

    @Override
    public void wrongHtml(TestResults counts, String actual) {
        this.fail(counts);
        this.addToBody(CellOnParse.label("expected") + "<hr>" + actual + CellOnParse.label("actual"));
    }

    private void addToBody(String msg) {
        if (this.parse.parts != null) {
            if (this.parse.parts.more == null) {
                this.parse.parts.trailer = msg;
            } else {
                this.parse.parts.more.leader = this.parse.parts.more.leader + msg;
            }
        } else {
            this.ensureBodyNotNull();
            this.parse.addToBody(msg);
        }
    }

    public void setEscapedText(String text) {
        this.setText(Fixture.escape(text));
    }

    public void setMultilineEscapedText(String text) {
        this.setText(HtmlUtils.escape(text));
    }

    @Override
    public String fullText() {
        return this.parse.body;
    }

    @Override
    public void setUnvisitedEscapedText(String s) {
        this.setUnvisitedText(Fixture.escape(s));
    }

    public void setUnvisitedMultilineEscapedText(String s) {
        this.setUnvisitedText(HtmlUtils.escape(s));
    }

    @Override
    public void setUnvisitedText(String s) {
        this.setText(Fixture.gray(s));
    }

    @Override
    public void passOrFailIfBlank(TestResults counts, VariableResolver resolver) {
        if (this.isBlank(resolver)) {
            this.pass(counts);
        } else {
            this.fail(counts, "", resolver);
        }
    }

    @Override
    public void passIfNotEmbedded(TestResults counts, VariableResolver resolver) {
        if (!this.hasEmbeddedTables(resolver)) {
            this.pass(counts);
        }
    }

    @Override
    public void setIsHidden() {
        this.cellIsInHiddenRow = true;
    }

    @Override
    public void setInnerTables(Tables tables) {
        this.parse.parts = tables.parse();
    }

    @Override
    public int getColumnSpan() {
        Matcher matcher = COLSPAN_PATTERN.matcher(this.parse.tag);
        int colspan = 1;
        if (matcher.matches()) {
            colspan = Integer.parseInt(matcher.group(2));
        }
        return colspan;
    }

    @Override
    public void setColumnSpan(int colspan) {
        if (colspan < 1) {
            return;
        }
        Matcher matcher = COLSPAN_PATTERN.matcher(this.parse.tag);
        if (matcher.matches()) {
            this.parse.tag = this.parse.tag.replace(matcher.group(1), CellOnParse.getColspanHtml(colspan));
        } else {
            this.parse.addToTag(CellOnParse.getColspanHtml(colspan));
        }
    }

    private static String getColspanHtml(int colspan) {
        return " colspan=\"" + colspan + "\"";
    }

    @Override
    public Table at(int i) {
        return this.getEmbeddedTables().at(i);
    }

    @Override
    public boolean isEmpty() {
        return this.getEmbeddedTables().isEmpty();
    }

    @Override
    public int size() {
        return this.getEmbeddedTables().size();
    }

    @Override
    public Iterator<Table> iterator() {
        return this.getEmbeddedTables().iterator();
    }

    @Override
    public CellOnParse add(Table table) {
        if (this.parse.parts == null) {
            this.parse.parts = TableFactory.tables(table).parse();
        } else {
            this.getEmbeddedTables().add(table);
        }
        return this;
    }

    @Override
    public TablesOnParse getEmbeddedTables() {
        return new TablesOnParse(this.parse.parts);
    }

    @Override
    public boolean hasEmbeddedTables(VariableResolver resolver) {
        this.text(resolver);
        return this.parse.parts != null;
    }

    @Override
    public String getType() {
        return "Cell";
    }

    @Override
    public void addPrefixToFirstInnerTable(String s) {
        this.at(0).setLeader(Fixture.label(s) + this.getLeader());
    }
}

