/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow.caller;

import fitlibrary.definedAction.ParameterBinder;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.TableFactory;
import java.util.Stack;

public class DefinedActionCallManager {
    protected final Stack<ParameterBinder> callsInProgress = new Stack();
    protected Table shows = TableFactory.table();

    public void startCall(ParameterBinder call) {
        this.clearShowsIfNoCallsInProgress();
        this.ensureNotInfinite(call);
        this.callsInProgress.push(call);
    }

    public void endCall(ParameterBinder call) {
        ParameterBinder top = this.callsInProgress.pop();
        if (top != call) {
            throw new RuntimeException("Unstack-like behaviour");
        }
    }

    public Table getShowsTable() {
        return this.shows;
    }

    public void addShow(Row row) {
        if (this.callsInProgress.isEmpty()) {
            return;
        }
        Row copy = (Row)row.deepCopy();
        this.shows.add(copy);
    }

    public boolean readyToShow() {
        return this.hasNoOutstandingCalls() && this.hasShows();
    }

    public String topName() {
        if (this.callsInProgress.isEmpty()) {
            return "storytest";
        }
        return this.callsInProgress.peek().getName();
    }

    private void ensureNotInfinite(Object call) {
        if (this.callsInProgress.contains(call)) {
            throw new FitLibraryException("Infinite calling of defined actions");
        }
    }

    private void clearShowsIfNoCallsInProgress() {
        if (this.callsInProgress.isEmpty()) {
            this.shows = TableFactory.table();
        }
    }

    private boolean hasShows() {
        return this.shows.size() > 0;
    }

    private boolean hasNoOutstandingCalls() {
        return this.callsInProgress.isEmpty();
    }
}

