/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow.caller;

import fitlibrary.runtime.RuntimeContextContainer;
import fitlibrary.traverse.workflow.caller.ValidCall;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;

public class TestPlainTextForTableForAction
extends TestCase {
    public void testNone() {
        String[] stringArray = new String[]{""};
        this.suceeds("", "blank", stringArray, 0);
    }

    public void testNoParameter() {
        String[] stringArray = new String[]{"<i>enters</i>"};
        this.suceeds("enters", "enters", stringArray, 0);
    }

    public void testNoParameterAsSpecialChar() {
        String[] stringArray = new String[]{"<i>+*</i>"};
        this.suceeds("+*", "plusStar", stringArray, 0);
    }

    public void testNoParameterAsSpecialChars() {
        String[] stringArray = new String[]{"<i>+ *</i>"};
        this.suceeds("+ *", "plusStar", stringArray, 0);
    }

    public void testNoParameterFailsAsMismatch() {
        this.fails("leaves", "enters", 0);
    }

    public void testNoParameterFailsAsArgAtStart() {
        this.fails("anna enters", "enters", 0);
    }

    public void testNoParameterFailsAsArgAtEnd() {
        this.fails("anna enters", "enters", 0);
    }

    public void testNoParameterButSeveralKeywords() {
        String[] stringArray = new String[]{"<i>enters the chat room</i>"};
        this.suceeds("enters the chat room", "entersTheChatRoom", stringArray, 0);
    }

    public void testNoParameterButSeveralKeywordsButOneArg() {
        this.fails("enters no chat room", "entersTheChatRoom", 0);
    }

    public void testOneArgAtStart() {
        String[] stringArray = new String[]{"", "anna", "<i>enters</i>"};
        this.suceeds("anna enters", "enters", stringArray, 1);
    }

    public void testOneArgAtStartWithSpecialChar() {
        String[] stringArray = new String[]{"", "anna", "<i>%</i>"};
        this.suceeds("anna %", "percent", stringArray, 1);
    }

    public void testOneArgAtStartWithMissingArgs() {
        String[] stringArray = new String[]{"", "anna", "<i>enters</i>", ""};
        this.suceeds("anna enters", "enters", stringArray, 2);
    }

    public void testOneArgAtStartFailsAsExtraArgs() {
        this.fails("anna enters", "enters", 0);
    }

    public void testOneArgAtEnd() {
        String[] stringArray = new String[]{"<i>enters</i>", "anna"};
        this.suceeds("enters anna", "enters", stringArray, 1);
    }

    public void testOneArgAtEndWithMissingArgs() {
        String[] stringArray = new String[]{"<i>enters</i>", "anna", "", ""};
        this.suceeds("enters anna", "enters", stringArray, 2);
    }

    public void testOneArgAtEndFailsAsExtraArgs() {
        this.fails("enters anna", "enters", 0);
    }

    public void testOneKeywordWithTwoArgs() {
        String[] stringArray = new String[]{"", "anna", "<i>leaves</i>", "lotr"};
        this.suceeds("anna leaves lotr", "leaves", stringArray, 2);
    }

    public void testOneSpecialKeywordWithTwoArgs() {
        String[] stringArray = new String[]{"", "anna", "<i>*</i>", "lotr"};
        this.suceeds("anna * lotr", "star", stringArray, 2);
    }

    public void testOneSpecialKeywordWithTwoArgsButOneMissingAfter() {
        String[] stringArray = new String[]{"", "anna", "<i>*</i>", ""};
        this.suceeds("anna *", "star", stringArray, 2);
    }

    public void testOneSpecialKeywordWithTwoArgsButOneMissing() {
        String[] stringArray = new String[]{"<i>*</i>", "anna", "", ""};
        this.suceeds("* anna", "star", stringArray, 2);
    }

    public void testSeveralArgsFromStart() {
        String[] stringArray = new String[]{"", "anna", "<i>enters the</i>", "lotr", "<i>chat room</i>"};
        this.suceeds("anna enters the lotr chat room", "entersTheChatRoom", stringArray, 2);
    }

    public void testSeveralArgsFromStartWithUpperCase() {
        String[] stringArray = new String[]{"", "anna", "<i>enters The</i>", "lotr", "<i>chat Room</i>"};
        this.suceeds("anna enters The lotr chat Room", "entersTheChatRoom", stringArray, 2);
    }

    public void testSeveralArgsNotFromStart() {
        String[] stringArray = new String[]{"<i>enters</i>", "anna", "<i>the</i>", "lotr", "<i>chat room</i>"};
        this.suceeds("enters anna the lotr chat room", "entersTheChatRoom", stringArray, 2);
    }

    public void testSeveralArgsWhereSomeArgsAreSeveralWords() {
        String[] stringArray = new String[]{"", "anna", "<i>enters the</i>", "lord of the rings", "<i>chat room</i>"};
        this.suceeds("anna enters the lord of the rings chat room", "entersTheChatRoom", stringArray, 2);
    }

    public void testSeveralArgsWithNumber() {
        String[] stringArray = new String[]{"", "anna", "<i>enters the</i>", "lord of 4 rings", "<i>chat room</i>"};
        this.suceeds("anna enters the lord of 4 rings chat room", "entersTheChatRoom", stringArray, 2);
    }

    public void testSeveralArgsWithNumbers() {
        String[] stringArray = new String[]{"", "5", "<i>enters the</i>", "lord of 4 5 rings", "<i>chat room</i>"};
        this.suceeds("5 enters the lord of 4 5 rings chat room", "entersTheChatRoom", stringArray, 2);
    }

    public void testSeveralArgsWithLastMissing() {
        String[] stringArray = new String[]{"", "anna", "<i>enters the chat room</i>", ""};
        this.suceeds("anna enters the chat room", "entersTheChatRoom", stringArray, 2);
    }

    public void testSeveralArgsWithSeveralMissing() {
        String[] stringArray = new String[]{"", "anna", "<i>enters the chat room</i>", "", "", ""};
        this.suceeds("anna enters the chat room", "entersTheChatRoom", stringArray, 3);
    }

    public void testNumberInMethodName() {
        String[] stringArray = new String[]{"<i>subtract 123</i>"};
        this.suceeds("subtract 123", "subtract123", stringArray, 0);
    }

    public void testNumberNotInMethodName() {
        String[] stringArray = new String[]{"<i>subtract</i>", "123"};
        this.suceeds("subtract 123", "subtract", stringArray, 1);
    }

    public void testKeywordsFailToMatch() {
        this.fails("room", "entersTheChatRoom", 0);
    }

    public void testSingleParameterFailsToMatchTwoArgs() {
        String string = "entersTheChatRoom";
        this.fails("anna enters the lotr chat room", string, 1);
    }

    private void suceeds(String string, String string2, String[] stringArray, int n) {
        TestPlainTextForTableForAction.assertEquals(Arrays.asList(stringArray), this.parse(string, string2, n));
    }

    private void fails(String string, String string2, int n) {
        TestPlainTextForTableForAction.assertEquals(null, this.parse(string, string2, n));
    }

    private List<String> parse(String string, String string2, int n) {
        ArrayList<ValidCall> arrayList = new ArrayList<ValidCall>();
        ValidCall.parseAction(Arrays.asList(string.split(" ")), string2, n, arrayList, new RuntimeContextContainer());
        if (arrayList.isEmpty()) {
            return null;
        }
        return ((ValidCall)arrayList.get(0)).getList();
    }
}

