/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow.special;

import fitlibrary.closure.ICalledMethodTarget;
import fitlibrary.exception.IgnoredException;
import fitlibrary.exception.table.ExtraCellsException;
import fitlibrary.exception.table.MissingCellsException;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.traverse.workflow.caller.TwoStageSpecial;
import fitlibrary.traverse.workflow.special.SpecialActionContext;
import fitlibrary.utility.option.None;
import fitlibrary.utility.option.Option;
import fitlibrary.utility.option.Some;
import ognl.Ognl;

public class PrefixSpecialAction {
    protected final SpecialActionContext actionContext;

    public PrefixSpecialAction(SpecialActionContext actionContext) {
        this.actionContext = actionContext;
    }

    public TwoStageSpecial check(final Row row) throws Exception {
        if (row.size() <= 2) {
            throw new MissingCellsException("Do");
        }
        final ICalledMethodTarget target = this.actionContext.findMethodFromRow(row, 1, 1);
        final Cell expectedCell = (Cell)row.last();
        return new TwoStageSpecial(){

            @Override
            public void run(TestResults testResults) {
                target.invokeAndCheckForSpecial((Row)row.fromAt(2), expectedCell, testResults, row, (Cell)row.at(0));
            }
        };
    }

    public TwoStageSpecial log(final Row row) throws Exception {
        if (row.size() <= 1) {
            throw new MissingCellsException("Do");
        }
        final ICalledMethodTarget target = this.actionContext.findMethodFromRow(row, 1, 0);
        return new TwoStageSpecial(){

            @Override
            public void run(TestResults testResults) {
                try {
                    Object result = target.invokeForSpecial((Row)row.fromAt(2), testResults, true, (Cell)row.at(0));
                    PrefixSpecialAction.this.reportBoolean(result, (Cell)row.at(1), testResults);
                    this.report(target.getResultString(result));
                }
                catch (Exception e) {
                    row.error(testResults, e);
                }
            }

            private void report(String text) {
                PrefixSpecialAction.this.actionContext.logMessage(text);
            }
        };
    }

    protected void reportBoolean(Object result, Cell cell, TestResults testResults) {
        if (result instanceof Boolean) {
            if (((Boolean)result).booleanValue()) {
                cell.pass(testResults);
            } else {
                cell.fail(testResults);
            }
        }
    }

    private Option<ICalledMethodTarget> getTarget(Row row) throws Exception {
        if (row.text(2, this.actionContext).equals("=")) {
            if (row.size() < 4) {
                throw new MissingCellsException("Do");
            }
            if (row.size() > 4) {
                throw new ExtraCellsException("");
            }
            return None.none();
        }
        return new Some<ICalledMethodTarget>(this.actionContext.findMethodFromRow(row, 2, 0));
    }

    public TwoStageSpecial set(final Row row) throws Exception {
        if (row.size() <= 2) {
            throw new MissingCellsException("Do");
        }
        final Option<ICalledMethodTarget> optionalTarget = this.target(row);
        return new TwoStageSpecial(){

            @Override
            public void run(TestResults testResults) {
                try {
                    String variableName = row.text(1, PrefixSpecialAction.this.actionContext);
                    if (optionalTarget.isSome()) {
                        Object result = ((ICalledMethodTarget)optionalTarget.get()).invokeForSpecial((Row)row.fromAt(3), testResults, true, (Cell)row.at(0));
                        PrefixSpecialAction.this.actionContext.setDynamicVariable(variableName, result);
                    } else if (((Cell)row.at(3)).hasEmbeddedTables(PrefixSpecialAction.this.actionContext)) {
                        PrefixSpecialAction.this.actionContext.setDynamicVariable(variableName, ((Cell)row.at(3)).getEmbeddedTables());
                    } else {
                        PrefixSpecialAction.this.actionContext.setDynamicVariable(variableName, Ognl.getValue((String)row.text(3, PrefixSpecialAction.this.actionContext), null));
                    }
                }
                catch (IgnoredException e) {
                }
                catch (Exception e) {
                    row.error(testResults, e);
                }
            }
        };
    }

    private Option<ICalledMethodTarget> target(Row row) throws Exception {
        if (row.size() == 4 && row.text(2, this.actionContext).equals("to") && ((Cell)row.at(3)).hasEmbeddedTables(this.actionContext)) {
            return None.none();
        }
        return this.getTarget(row);
    }

    public TwoStageSpecial setSymbolNamed(final Row row) throws Exception {
        if (row.size() <= 2) {
            throw new MissingCellsException("Do");
        }
        final Option<ICalledMethodTarget> optionalTarget = this.getTarget(row);
        return new TwoStageSpecial(){

            @Override
            public void run(TestResults testResults) {
                try {
                    String variableName = row.text(1, PrefixSpecialAction.this.actionContext);
                    if (optionalTarget.isSome()) {
                        Object result = ((ICalledMethodTarget)optionalTarget.get()).invokeForSpecial((Row)row.fromAt(3), testResults, true, (Cell)row.at(0));
                        PrefixSpecialAction.this.actionContext.setFitVariable(variableName, result);
                    } else {
                        PrefixSpecialAction.this.actionContext.setFitVariable(variableName, Ognl.getValue((String)row.text(3, PrefixSpecialAction.this.actionContext), null));
                    }
                }
                catch (IgnoredException e) {
                }
                catch (Exception e) {
                    row.error(testResults, e);
                }
            }
        };
    }

    public static enum NotSyle {
        PASSES_ON_EXCEPION,
        ERROR_ON_EXCEPION;

    }

    public static enum ShowSyle {
        ORDINARY,
        ESCAPED,
        LOGGED;

    }
}

