/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow.special;

import fitlibrary.exception.IgnoredException;
import fitlibrary.exception.parse.BadNumberException;
import fitlibrary.flow.GlobalActionScope;
import fitlibrary.special.DoAction;
import java.lang.reflect.InvocationTargetException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestEnsure {
    Mockery context = new Mockery();
    DoAction action = (DoAction)this.context.mock(DoAction.class);
    GlobalActionScope globalActionScope = new GlobalActionScope();

    @Test
    public void passesWithNullResult() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.one(TestEnsure.this.action)).run();
                this.will(1.returnValue(null));
            }
        });
        MatcherAssert.assertThat((Object)this.globalActionScope.ensure(this.action), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void passesWithTrueResult() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.one(TestEnsure.this.action)).run();
                this.will(2.returnValue((Object)true));
            }
        });
        MatcherAssert.assertThat((Object)this.globalActionScope.ensure(this.action), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void failsWithFalseResult() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.one(TestEnsure.this.action)).run();
                this.will(3.returnValue((Object)false));
            }
        });
        MatcherAssert.assertThat((Object)this.globalActionScope.ensure(this.action), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test(expected=IgnoredException.class)
    public void ignoredWithIgnoredException() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.one(TestEnsure.this.action)).run();
                this.will(4.throwException((Throwable)new IgnoredException()));
            }
        });
        MatcherAssert.assertThat((Object)this.globalActionScope.ensure(this.action), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test(expected=BadNumberException.class)
    public void errorWithException() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.one(TestEnsure.this.action)).run();
                this.will(5.throwException((Throwable)new BadNumberException()));
            }
        });
        MatcherAssert.assertThat((Object)this.globalActionScope.ensure(this.action), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test(expected=InvocationTargetException.class)
    public void errorWithEmbeddedException() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.one(TestEnsure.this.action)).run();
                this.will(6.throwException((Throwable)new InvocationTargetException(new BadNumberException())));
            }
        });
        MatcherAssert.assertThat((Object)this.globalActionScope.ensure(this.action), (Matcher)CoreMatchers.is((Object)false));
    }
}

