/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow.special;

import fitlibrary.exception.NotRejectedException;
import fitlibrary.exception.parse.BadNumberException;
import fitlibrary.flow.GlobalActionScope;
import fitlibrary.special.DoAction;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestNotTrue {
    Mockery context = new Mockery();
    DoAction action = (DoAction)this.context.mock(DoAction.class);
    GlobalActionScope globalActionScope = new GlobalActionScope();

    @Test
    public void trueWithFalseResult() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.one(TestNotTrue.this.action)).run();
                this.will(1.returnValue((Object)false));
            }
        });
        MatcherAssert.assertThat((Object)this.globalActionScope.notTrue(this.action), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test(expected=BadNumberException.class)
    public void failsWithException() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.one(TestNotTrue.this.action)).run();
                this.will(2.throwException((Throwable)new BadNumberException()));
            }
        });
        this.globalActionScope.notTrue(this.action);
    }

    @Test
    public void falseWithTrueResult() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.one(TestNotTrue.this.action)).run();
                this.will(3.returnValue((Object)true));
            }
        });
        MatcherAssert.assertThat((Object)this.globalActionScope.notTrue(this.action), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test(expected=NotRejectedException.class)
    public void exceptionWithNullResult() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.one(TestNotTrue.this.action)).run();
                this.will(4.returnValue(null));
            }
        });
        this.globalActionScope.notTrue(this.action);
    }
}

