/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow.special;

import fitlibrary.exception.IgnoredException;
import fitlibrary.flow.GlobalActionScope;
import fitlibrary.special.DoAction;
import java.math.BigDecimal;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestShowAfter {
    Mockery context = new Mockery();
    DoAction action = (DoAction)this.context.mock(DoAction.class);
    GlobalActionScope globalActionScope = new GlobalActionScope();

    @Test
    public void textIsShown() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.one(TestShowAfter.this.action)).run();
                this.will(1.returnValue((Object)"nz"));
                ((DoAction)this.one(TestShowAfter.this.action)).showAfter("nz");
            }
        });
        this.globalActionScope.showAfter(this.action);
    }

    @Test
    public void objectIsShown() throws Exception {
        final BigDecimal bigDecimal = new BigDecimal(4444444);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.one(TestShowAfter.this.action)).run();
                this.will(2.returnValue((Object)bigDecimal));
                ((DoAction)this.one(TestShowAfter.this.action)).showAfter(bigDecimal);
            }
        });
        this.globalActionScope.showAfter(this.action);
    }

    @Test
    public void nothingShownWithNullResult() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.one(TestShowAfter.this.action)).run();
                this.will(3.returnValue(null));
            }
        });
        this.globalActionScope.showAfter(this.action);
    }

    @Test(expected=Exception.class)
    public void exceptionIsPassedOn() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.one(TestShowAfter.this.action)).run();
                this.will(4.throwException((Throwable)new IgnoredException()));
            }
        });
        this.globalActionScope.showAfter(this.action);
    }
}

