/*
 * Decompiled with CFR 0.152.
 */
package fitlibraryGeneric;

import fitlibrary.DoFixture;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.exception.parse.BadNumberException;
import fitlibrary.parser.ParserTestCase;
import fitlibrary.parser.lookup.ParserSelectorForType;
import fitlibrary.traverse.workflow.DoEvaluator;
import fitlibraryGeneric.generic.LocalParameterizedType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class TestDirectAccessToParser {
    private DoEvaluator doFixture = ParserTestCase.evaluatorWithRuntime(new MyFixture());

    @Test
    public void testParseInt() throws Exception {
        MatcherAssert.assertThat((Object)ParserSelectorForType.evaluate(this.doFixture, Integer.TYPE, "3"), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test(expected=BadNumberException.class)
    public void testParseIntFails() throws Exception {
        ParserSelectorForType.evaluate(this.doFixture, Integer.TYPE, "three");
    }

    @Test
    public void testParseWithFinder() throws Exception {
        MatcherAssert.assertThat((Object)ParserSelectorForType.evaluate(this.doFixture, X.class, "3"), (Matcher)CoreMatchers.is((Object)new X("3")));
    }

    @Test(expected=FitLibraryException.class)
    public void testParseWithOutFinder() throws Exception {
        ParserSelectorForType.evaluate(this.doFixture, Y.class, "3");
    }

    @Test
    public void testParseWithEnumFinder() throws Exception {
        MatcherAssert.assertThat((Object)ParserSelectorForType.evaluate(this.doFixture, En.class, "a"), (Matcher)CoreMatchers.is((Object)((Object)En.A)));
    }

    @Test
    public void testParseWithGenericFinder() throws Exception {
        LocalParameterizedType localParameterizedType = new LocalParameterizedType((Type)((Object)TestDirectAccessToParser.class), (Type)((Object)Gen.class), new Type[]{Integer.class});
        MatcherAssert.assertThat((Object)ParserSelectorForType.evaluate(this.doFixture, localParameterizedType, "3"), (Matcher)CoreMatchers.is(new Gen<Integer>(3)));
    }

    @Test
    public void testParseWithGenericEnumFinder() throws Exception {
        LocalParameterizedType localParameterizedType = new LocalParameterizedType((Type)((Object)TestDirectAccessToParser.class), (Type)((Object)Gen.class), new Type[]{En.class});
        MatcherAssert.assertThat((Object)ParserSelectorForType.evaluate(this.doFixture, localParameterizedType, "A"), (Matcher)CoreMatchers.is(new Gen<En>(En.A)));
    }

    @Test
    public void testParseWithGenericListEnumFinder() throws Exception {
        LocalParameterizedType localParameterizedType = new LocalParameterizedType((Type)((Object)TestDirectAccessToParser.class), (Type)((Object)List.class), new Type[]{En.class});
        LocalParameterizedType localParameterizedType2 = new LocalParameterizedType((Type)((Object)TestDirectAccessToParser.class), (Type)((Object)Gen.class), localParameterizedType);
        ArrayList<En> arrayList = new ArrayList<En>();
        arrayList.add(En.A);
        arrayList.add(En.B);
        MatcherAssert.assertThat((Object)ParserSelectorForType.evaluate(this.doFixture, localParameterizedType2, "a, b"), (Matcher)CoreMatchers.is(new Gen(arrayList)));
    }

    public static enum En {
        A,
        B;

    }

    public static class Gen<T> {
        private T t;

        public Gen(T t) {
            this.t = t;
        }

        public boolean equals(Object object) {
            return this.t.equals(((Gen)object).t);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    public static class Y {
    }

    public static class X {
        private String s;

        public X(String string) {
            this.s = string;
        }

        public boolean equals(Object object) {
            return this.s.equals(((X)object).s);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    public static class MyFixture
    extends DoFixture {
        public X findX(String string) {
            return new X(string);
        }

        public Gen findGen(String string, Type type) throws Exception {
            Type type2 = ((ParameterizedType)type).getActualTypeArguments()[0];
            if (type2 == Integer.class) {
                return new Gen<Integer>(Integer.valueOf(string));
            }
            if (type2 == En.class) {
                return new Gen<En>((En)((Object)ParserSelectorForType.evaluate(this, En.class, string)));
            }
            if (((ParameterizedType)type2).getRawType() == List.class && ((ParameterizedType)type2).getActualTypeArguments()[0] == En.class) {
                return new Gen<List>((List)ParserSelectorForType.evaluate(this, type2, string));
            }
            throw new RuntimeException();
        }
    }
}

