/*
 * Decompiled with CFR 0.152.
 */
package fitlibraryGeneric.set;

import fitlibrary.exception.table.RowWrongWidthException;
import fitlibrary.parser.Parser;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.traverse.Traverse;
import fitlibraryGeneric.typed.GenericTyped;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class NestingSetTraverse
extends Traverse {
    private Set<Object> set;
    private GenericTyped typed;

    public NestingSetTraverse(Set<Object> set, GenericTyped type) {
        this.set = set;
        this.typed = type;
    }

    @Override
    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        Row row;
        Parser parser = this.typed.parser(this);
        ArrayList<Object> listOfActuals = new ArrayList<Object>(this.set);
        for (int rowNo = 0; rowNo < table.size(); ++rowNo) {
            row = (Row)table.at(rowNo);
            try {
                if (row.size() != 1) {
                    throw new RowWrongWidthException(1);
                }
                this.matchActual((Cell)row.at(0), parser, listOfActuals, table.size(), testResults);
                continue;
            }
            catch (Exception e) {
                row.error(testResults, e);
            }
        }
        for (int i = 0; i < listOfActuals.size(); ++i) {
            row = table.newRow();
            Cell cell = row.addCell();
            try {
                cell.actualElementMissing(testResults, parser.show(listOfActuals.get(i)));
                continue;
            }
            catch (Exception e) {
                cell.error(testResults, e);
            }
        }
        return this.set;
    }

    private void matchActual(Cell cell, Parser adapter, List<Object> listOfActuals, int tableSize, TestResults testResults) throws Exception {
        if (tableSize == 1 && listOfActuals.size() == 1) {
            adapter.matches(cell, listOfActuals.get(0), testResults);
            listOfActuals.remove(0);
            return;
        }
        for (int i = 0; i < listOfActuals.size(); ++i) {
            Object element = listOfActuals.get(i);
            if (!adapter.matches((Cell)cell.deepCopy(), element, testResults)) continue;
            adapter.matches(cell, element, testResults);
            listOfActuals.remove(i);
            return;
        }
        cell.expectedElementMissing(testResults);
    }
}

