/*
 * Decompiled with CFR 0.152.
 */
package fitlibraryGeneric.typed;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.exception.UnboundTypeException;
import fitlibrary.object.Finder;
import fitlibrary.parser.Parser;
import fitlibrary.parser.lookup.ParserSelectorForType;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.Typed;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.ClassUtility;
import fitlibraryGeneric.generic.GenericTypeUtility;
import fitlibraryGeneric.generic.LocalGenericArrayType;
import fitlibraryGeneric.generic.LocalParameterizedType;
import fitlibraryGeneric.object.GenericFinder;
import fitlibraryGeneric.typed.GenericTypedObject;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

public class GenericTyped
implements Typed {
    private Type type;
    private boolean hasMethodOrField;
    private Map<TypeVariable<?>, Type> bindings = new HashMap();
    private static ParserSelectorForType parserSelector = new ParserSelectorForType();

    public GenericTyped(Type type) {
        this.type = type;
        if (this.isGeneric()) {
            this.makeTypeBindings(this.asParameterizedType(), this.asParameterizedType().getActualTypeArguments(), "");
        }
    }

    public GenericTyped(Type type, boolean hasMethodOrField) {
        this(type);
        this.hasMethodOrField = hasMethodOrField;
    }

    @Override
    public Class<?> asClass() {
        return GenericTypeUtility.getClassType(this.type);
    }

    @Override
    public boolean hasMethodOrField() {
        return this.hasMethodOrField;
    }

    @Override
    public GenericTyped getComponentTyped() {
        return new GenericTyped(this.getComponentType());
    }

    public GenericTyped getComponentTyped(int index) {
        return new GenericTyped(this.getComponentType(index));
    }

    @Override
    public boolean isPrimitive() {
        return this.asClass().isPrimitive();
    }

    public boolean isEffectivelyPrimitive() {
        return ClassUtility.isEffectivelyPrimitive(this.asClass());
    }

    @Override
    public boolean isGeneric() {
        return this.type instanceof ParameterizedType;
    }

    public Type getComponentType() {
        return this.getComponentType(0);
    }

    public Type getComponentType(int index) {
        switch (GenericTypeUtility.typeCases(this.type)) {
            case CLASS_TYPE: {
                Class classType = (Class)this.type;
                if (index == 0 && classType.isArray()) {
                    return classType.getComponentType();
                }
                throw new FitLibraryException("A " + this.type + " doesn't have a component type");
            }
            case PARAMETERIZED_TYPE: {
                ParameterizedType pType = (ParameterizedType)this.type;
                if (pType.getActualTypeArguments().length <= index) break;
                return pType.getActualTypeArguments()[index];
            }
            case GENERIC_ARRAY: {
                if (index != 0) break;
                GenericArrayType aType = (GenericArrayType)this.type;
                return aType.getGenericComponentType();
            }
            case TYPE_VARIABLE: 
            case WILDCARD_TYPE: {
                throw new FitLibraryException("A " + this.type + " doesn't have a component type");
            }
        }
        return null;
    }

    public GenericTyped bindToGenericType(Type givenType, String context) {
        return new GenericTyped(this.bind(givenType, context));
    }

    public Type bind(Type givenType, String context) {
        Type resultingType = null;
        switch (GenericTypeUtility.typeCases(givenType)) {
            case TYPE_VARIABLE: {
                resultingType = this.bindings.get(givenType);
                if (resultingType != null) break;
                throw new UnboundTypeException(givenType, context);
            }
            case PARAMETERIZED_TYPE: {
                ParameterizedType parameterizedType = GenericTypeUtility.asParameterizedType(givenType);
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                resultingType = new LocalParameterizedType(parameterizedType.getOwnerType(), parameterizedType.getRawType(), this.bind(actualTypeArguments, context));
                break;
            }
            case CLASS_TYPE: {
                resultingType = givenType;
                break;
            }
            case GENERIC_ARRAY: {
                Type genericComponentType = ((GenericArrayType)givenType).getGenericComponentType();
                LocalGenericArrayType local = new LocalGenericArrayType(this.bind(genericComponentType, context));
                if (GenericTypeUtility.typeCases(local.getGenericComponentType()) == GenericTypeUtility.GenericCases.CLASS_TYPE) {
                    resultingType = local.asClass();
                    break;
                }
                resultingType = local;
                break;
            }
            case WILDCARD_TYPE: {
                throw new RuntimeException("Unable to handle wildcard types");
            }
        }
        if (resultingType == null || !this.isFullyBound(resultingType)) {
            throw new UnboundTypeException(resultingType, context);
        }
        return resultingType;
    }

    private boolean isFullyBound(Type givenType) {
        switch (GenericTypeUtility.typeCases(givenType)) {
            case TYPE_VARIABLE: 
            case WILDCARD_TYPE: {
                return false;
            }
            case CLASS_TYPE: {
                return true;
            }
            case GENERIC_ARRAY: {
                GenericArrayType genericArrayType = (GenericArrayType)givenType;
                return this.isFullyBound(genericArrayType.getGenericComponentType());
            }
            case PARAMETERIZED_TYPE: {
                ParameterizedType parameterizedType = (ParameterizedType)givenType;
                for (Type t : parameterizedType.getActualTypeArguments()) {
                    if (this.isFullyBound(t)) continue;
                    return false;
                }
                break;
            }
        }
        return true;
    }

    public GenericTyped[] bindToGenericTypes(Type[] types, String context) {
        GenericTyped[] results = new GenericTyped[types.length];
        for (int i = 0; i < types.length; ++i) {
            results[i] = this.bindToGenericType(types[i], context);
        }
        return results;
    }

    public Type[] bind(Type[] types, String context) {
        Type[] results = new Type[types.length];
        for (int i = 0; i < types.length; ++i) {
            results[i] = this.bind(types[i], context);
        }
        return results;
    }

    private ParameterizedType asParameterizedType() {
        return (ParameterizedType)this.type;
    }

    public void assertHasParameters(int expectedCount) {
        if (this.actualCount() != expectedCount) {
            throw new RuntimeException("Expected " + expectedCount + "type parameters, but found " + this.actualCount());
        }
    }

    private int actualCount() {
        return this.asParameterizedType().getActualTypeArguments().length;
    }

    @Override
    public Object newInstance() throws InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        return ClassUtility.newInstance(this.asClass());
    }

    @Override
    public String getClassName() {
        return this.asClass().getName();
    }

    public String toString() {
        return GenericTypeUtility.toString(this.type);
    }

    @Override
    public String simpleClassName() {
        return ClassUtility.simpleClassName(this.asClass());
    }

    @Override
    public TypedObject typedObject(Object subject) {
        return new GenericTypedObject(subject, this);
    }

    @Override
    public boolean isArray() {
        return this.asClass().isArray();
    }

    @Override
    public TypedObject newTypedInstance() throws InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        return this.typedObject(this.newInstance());
    }

    private void makeTypeBindings(ParameterizedType parameterisedType, Type[] actualTypeArguments, String context) {
        Class rawType = (Class)parameterisedType.getRawType();
        TypeVariable<Class<T>>[] formalTypeParameters = rawType.getTypeParameters();
        if (formalTypeParameters.length != actualTypeArguments.length) {
            throw new RuntimeException("Lengths not the same for the formal and actual type arguments");
        }
        for (int i = 0; i < formalTypeParameters.length; ++i) {
            this.bindings.put(formalTypeParameters[i], actualTypeArguments[i]);
        }
        this.makeTypeBindingsForSuperClasses(rawType, context);
    }

    private void makeTypeBindingsForSuperClasses(Class<?> rawType, String context) {
        if (rawType == null) {
            return;
        }
        Type genericSuperclass = rawType.getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType) {
            this.makeTypeBindings((ParameterizedType)genericSuperclass, this.bind(((ParameterizedType)genericSuperclass).getActualTypeArguments(), context), context);
        } else {
            this.makeTypeBindingsForSuperClasses(rawType.getSuperclass(), context);
        }
    }

    public GenericTypeUtility.GenericCases typeCases() {
        return GenericTypeUtility.typeCases(this.type);
    }

    @Override
    public Parser parser(Evaluator evaluator) {
        return this.on(evaluator, this, false);
    }

    @Override
    public Parser resultParser(Evaluator evaluator) {
        return this.on(evaluator, this, true);
    }

    @Override
    public Parser on(Evaluator evaluator, Typed typed, boolean isResult) {
        return parserSelector.parserFor(evaluator, typed, isResult);
    }

    @Override
    public boolean isEnum() {
        return this.asClass().isEnum();
    }

    @Override
    public Finder getFinder(Evaluator evaluator) {
        return new GenericFinder(this, evaluator);
    }

    public Type asType() {
        return this.type;
    }
}

