/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.TiffDecoder;
import org.jpedal.sun.LZWDecoder;
import org.jpedal.sun.LZWDecoder2;
import org.jpedal.sun.TIFFFaxDecoder;
import org.jpedal.sun.TIFFLZWDecoder;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class PdfFilteredReader
extends PdfFileReader {
    final boolean debugCaching = false;
    private boolean hasJAI = false;
    private boolean checkJAI = false;
    BufferedOutputStream streamCache = null;
    BufferedInputStream bis = null;
    private String filter_type;
    private static final long[] base_85_indices = new long[]{52200625L, 614125L, 7225L, 85L, 1L};
    private static final long[] hex_indices = new long[]{0x1000000L, 65536L, 256L, 1L};

    public final byte[] decodeFilters(byte[] object, String string, Map map, int n, int n2, boolean bl, String string2) throws Exception {
        Object object2;
        boolean bl2;
        this.streamCache = null;
        this.bis = null;
        Map map2 = new HashMap();
        boolean bl3 = string2 != null && object == null ? true : (bl2 = false);
        if (map != null && (object2 = map.get("DecodeParms")) != null) {
            if (object2 instanceof String) {
                this.convertStringToMap(map2, object2);
            } else {
                map2 = (Map)object2;
            }
        }
        if (string.startsWith("[")) {
            string = string.endsWith("]") ? string.substring(1, string.length() - 1) : string.substring(1);
        } else if (string.endsWith("]")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.length() > 0) {
            object2 = new StringTokenizer(string);
            boolean bl4 = false;
            while (((StringTokenizer)object2).hasMoreTokens()) {
                boolean bl5;
                this.filter_type = ((StringTokenizer)object2).nextToken();
                boolean bl6 = bl5 = this.filter_type.indexOf("/DCTDecode") != -1 || this.filter_type.indexOf("/JPXDecode") != -1;
                if (bl2 && !bl5 && string2 != null) {
                    this.setupCachedObjectForDecoding((byte[])object, string2, false, this.filter_type);
                }
                if (!this.filter_type.startsWith("/")) continue;
                bl4 = false;
                if (this.filter_type.indexOf("/FlateDecode") != -1 | this.filter_type.indexOf("/Fl") != -1) {
                    object = this.flateDecode((byte[])object, map2, string2);
                } else if (this.filter_type.indexOf("/ASCII85Decode") != -1 | this.filter_type.indexOf("/A85") != -1) {
                    if (object != null) {
                        object = this.ascii85DecodeNEW((byte[])object);
                    }
                    if (this.bis != null) {
                        this.ascii85Decode(this.bis, this.streamCache);
                    }
                } else if (this.isCCITTEncoded(this.filter_type)) {
                    Object object3;
                    if (!this.checkJAI) {
                        this.checkJAI = true;
                        object3 = this.getClass().getClassLoader().getResourceAsStream("javax/media/jai/RenderedOp.class");
                        if (object3 == null) {
                            LogWriter.writeLog("[PDF] WARNING-JAI class not present on classpath");
                            System.err.println("[PDF] WARNING-JAI class not present on classpath");
                        } else {
                            this.hasJAI = true;
                        }
                    }
                    if (bl2) {
                        int n3 = this.bis.available();
                        object = new byte[n3];
                        this.bis.read((byte[])object);
                    }
                    object3 = null;
                    if (bl && this.hasJAI && object != null) {
                        TiffDecoder tiffDecoder = new TiffDecoder(n, n2, map2, (byte[])object);
                        object3 = tiffDecoder.getRawBytes();
                    }
                    object = object3 == null ? this.ccittDecode((byte[])object, map2, n, n2) : (Object)object3;
                    if (bl2) {
                        this.streamCache.write((byte[])object);
                    }
                } else if (this.filter_type.indexOf("/LZW") != -1) {
                    object = this.lzwDecode(this.bis, this.streamCache, (byte[])object, map2, n, n2, string2);
                } else if (this.filter_type.indexOf("/RunLengthDecode") != -1 | this.filter_type.indexOf("/RL") != -1) {
                    object = this.runLengthDecode((byte[])object, this.bis, this.streamCache);
                } else if (this.filter_type.indexOf("/ASCIIHexDecode") != -1 | this.filter_type.indexOf("/AHx") != -1) {
                    if (object != null) {
                        object = this.asciiHexDecode((byte[])object);
                    }
                    if (this.bis != null) {
                        this.asciiHexDecode(this.bis, this.streamCache);
                    }
                } else if (bl5) {
                    bl4 = true;
                } else {
                    LogWriter.writeLog("[PDF] Unsupported decompression stream " + this.filter_type);
                    object = null;
                }
                if (!bl2) continue;
                if (this.bis != null) {
                    this.bis.close();
                }
                if (this.streamCache == null) continue;
                this.streamCache.flush();
                this.streamCache.close();
            }
        }
        return object;
    }

    private void setupCachedObjectForDecoding(byte[] byArray, String string, boolean bl, String string2) throws IOException, FileNotFoundException {
        File file = File.createTempFile("jpedal", ".raw");
        this.cachedObjects.put(file.getAbsolutePath(), "x");
        ObjectStore.copy(string, file.getAbsolutePath());
        File file2 = new File(string);
        file2.delete();
        this.streamCache = new BufferedOutputStream(new FileOutputStream(string));
        if (bl) {
            System.out.println("cache size=" + file.length());
        }
        this.bis = new BufferedInputStream(new FileInputStream(file));
        if (byArray != null) {
            // empty if block
        }
    }

    public void convertStringToMap(Map map, Object object) {
        StringTokenizer stringTokenizer = new StringTokenizer(Strip.removeArrayDeleminators((String)object));
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.startsWith("<<")) {
                string = string.substring(2).trim();
            }
            if (!string.startsWith("/")) continue;
            String string2 = string.substring(1);
            string = stringTokenizer.nextToken();
            if (string.endsWith(">>")) {
                string = string.substring(0, string.length() - 2).trim();
            }
            map.put(string2, string);
        }
    }

    private byte[] runLengthDecode(byte[] byArray, BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        byte by = 0;
        int n4 = 0;
        if (byArray != null) {
            n = byArray.length;
            byteArrayOutputStream = new ByteArrayOutputStream(n);
        }
        if (bufferedInputStream != null) {
            n = bufferedInputStream.available();
        }
        if (byArray != null && bufferedInputStream != null && byArray.length != bufferedInputStream.available()) {
            System.out.println("Different lengths in RunLengthDecode");
            System.out.println(byArray.length + " " + bufferedInputStream.available());
            System.exit(1);
        }
        for (int i = 0; i < n; ++i) {
            int n5;
            if (byArray != null) {
                n2 = byArray[i];
            }
            if (bufferedInputStream != null) {
                n3 = bufferedInputStream.read();
                if (n3 >= 128) {
                    n3 -= 256;
                }
                if (byArray != null && n2 != n3) {
                    System.out.println("Len wrong =" + n2 + " " + n3);
                    System.exit(1);
                }
                n2 = n3;
            }
            if (n2 < 0) {
                n2 = 256 + n2;
            }
            if (n2 == 128) {
                i = n;
                continue;
            }
            if (n2 > 128) {
                ++i;
                n2 = 257 - n2;
                if (byArray != null) {
                    by = byArray[i];
                }
                if (bufferedOutputStream != null && (n4 = bufferedInputStream.read()) >= 128) {
                    n4 -= 256;
                }
                if (byArray != null && bufferedInputStream != null && by != n4) {
                    System.out.println("Different values in RunLengthDecode");
                    System.out.println(by + " " + n4 + " " + bufferedOutputStream);
                    System.exit(1);
                }
                for (n5 = 0; n5 < n2; ++n5) {
                    if (byArray != null) {
                        byteArrayOutputStream.write(by);
                    }
                    if (bufferedOutputStream == null) continue;
                    bufferedOutputStream.write(n4);
                }
                continue;
            }
            ++i;
            ++n2;
            for (n5 = 0; n5 < n2; ++n5) {
                if (byArray != null) {
                    by = byArray[i + n5];
                    byteArrayOutputStream.write(by);
                }
                if (bufferedOutputStream != null) {
                    n4 = bufferedInputStream.read();
                    if (n4 >= 128) {
                        n4 -= 256;
                    }
                    bufferedOutputStream.write(n4);
                }
                if (byArray == null || bufferedInputStream == null || by == n4) continue;
                System.out.println("2Different values in RunLengthDecode");
                System.out.println(by + " " + n4);
                System.exit(1);
            }
            i = i + n2 - 1;
        }
        if (byArray != null) {
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    private byte[] runJBIGDecode(byte[] byArray, BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        byte by = 0;
        int n4 = 0;
        if (byArray != null) {
            n = byArray.length;
            byteArrayOutputStream = new ByteArrayOutputStream(n);
        }
        if (bufferedInputStream != null) {
            n = bufferedInputStream.available();
        }
        if (byArray != null && bufferedInputStream != null && byArray.length != bufferedInputStream.available()) {
            System.out.println("Different lengths in RunLengthDecode");
            System.out.println(byArray.length + " " + bufferedInputStream.available());
            System.exit(1);
        }
        for (int i = 0; i < n; ++i) {
            int n5;
            if (byArray != null) {
                n2 = byArray[i];
            }
            if (bufferedInputStream != null) {
                n3 = bufferedInputStream.read();
                if (n3 >= 128) {
                    n3 -= 256;
                }
                if (byArray != null && n2 != n3) {
                    System.out.println("Len wrong =" + n2 + " " + n3);
                    System.exit(1);
                }
                n2 = n3;
            }
            if (n2 < 0) {
                n2 = 256 + n2;
            }
            if (n2 == 128) {
                i = n;
                continue;
            }
            if (n2 > 128) {
                ++i;
                n2 = 257 - n2;
                if (byArray != null) {
                    by = byArray[i];
                }
                if (bufferedOutputStream != null && (n4 = bufferedInputStream.read()) >= 128) {
                    n4 -= 256;
                }
                if (byArray != null && bufferedInputStream != null && by != n4) {
                    System.out.println("Different values in RunLengthDecode");
                    System.out.println(by + " " + n4 + " " + bufferedOutputStream);
                    System.exit(1);
                }
                for (n5 = 0; n5 < n2; ++n5) {
                    if (byArray != null) {
                        byteArrayOutputStream.write(by);
                    }
                    if (bufferedOutputStream == null) continue;
                    bufferedOutputStream.write(n4);
                }
                continue;
            }
            ++i;
            ++n2;
            for (n5 = 0; n5 < n2; ++n5) {
                if (byArray != null) {
                    by = byArray[i + n5];
                    byteArrayOutputStream.write(by);
                }
                if (bufferedOutputStream != null) {
                    n4 = bufferedInputStream.read();
                    if (n4 >= 128) {
                        n4 -= 256;
                    }
                    bufferedOutputStream.write(n4);
                }
                if (byArray == null || bufferedInputStream == null || by == n4) continue;
                System.out.println("2Different values in RunLengthDecode");
                System.out.println(by + " " + n4);
                System.exit(1);
            }
            i = i + n2 - 1;
        }
        if (byArray != null) {
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    private final byte[] lzwDecode(BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream, byte[] byArray, Map map, int n, int n2, String string) throws Exception {
        Object object;
        int n3 = 1;
        int n4 = 8;
        int n5 = 1;
        int n6 = n2;
        int n7 = n;
        String string2 = (String)map.get("Predictor");
        if (string2 != null) {
            n3 = Integer.parseInt(string2);
        }
        if ((string2 = (String)map.get("Rows")) != null) {
            n6 = Integer.parseInt(string2);
        }
        if ((string2 = (String)map.get("Columns")) != null) {
            n7 = Integer.parseInt(string2);
        }
        if ((string2 = (String)map.get("EarlyChange")) != null) {
            n5 = Integer.parseInt(string2);
        }
        if ((string2 = (String)map.get("BitsPerComponent")) != null) {
            n4 = Integer.parseInt(string2);
        }
        Object var14_14 = null;
        if (n6 * n7 == 1) {
            if (byArray != null) {
                byte[] byArray2 = new byte[n4 * n6 * (n7 + 7 >> 3)];
                TIFFLZWDecoder tIFFLZWDecoder = new TIFFLZWDecoder(n7, n3, n4);
                tIFFLZWDecoder.decode(byArray, byArray2, n6);
                return this.applyPredictor(n3, map, byArray2);
            }
            return null;
        }
        if (bufferedInputStream != null) {
            object = new LZWDecoder2();
            ((LZWDecoder2)object).decode(byArray, bufferedOutputStream, bufferedInputStream);
        }
        if (byArray != null) {
            object = new ByteArrayOutputStream();
            LZWDecoder lZWDecoder = new LZWDecoder();
            lZWDecoder.decode(byArray, (OutputStream)object);
            ((ByteArrayOutputStream)object).close();
            byArray = ((ByteArrayOutputStream)object).toByteArray();
        }
        if (n3 != 1 && n3 != 10) {
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            if (string != null) {
                this.setupCachedObjectForDecoding(byArray, string, false, this.filter_type);
            }
        }
        byArray = this.applyPredictor(n3, map, byArray);
        return byArray;
    }

    private final byte[] ccittDecode(byte[] byArray, Map map, int n, int n2) throws Exception {
        boolean bl = false;
        int n3 = 1728;
        int n4 = n2;
        int n5 = 0;
        boolean bl2 = false;
        String string = (String)map.get("K");
        if (string != null) {
            n5 = Integer.parseInt(string);
        }
        if ((string = (String)map.get("EncodedByteAlign")) != null) {
            bl2 = Boolean.valueOf(string);
        }
        if ((string = (String)map.get("BlackIs1")) != null) {
            bl = Boolean.valueOf(string);
        }
        if ((string = (String)map.get("Rows")) != null) {
            n4 = Integer.parseInt(string);
        }
        if ((string = (String)map.get("Columns")) != null) {
            n3 = Integer.parseInt(string);
        }
        byte[] byArray2 = new byte[n4 * (n3 + 7 >> 3)];
        try {
            TIFFFaxDecoder tIFFFaxDecoder = new TIFFFaxDecoder(1, n3, n4);
            if (n5 == 0) {
                tIFFFaxDecoder.decode1D(byArray2, byArray, 0, n4);
            } else if (n5 > 0) {
                tIFFFaxDecoder.decode2D(byArray2, byArray, 0, n4, 0L);
            } else if (n5 < 0) {
                tIFFFaxDecoder.decodeT6(byArray2, byArray, 0, n4, 0L, bl2);
            }
            if (!bl) {
                for (int i = 0; i < byArray2.length; ++i) {
                    byArray2[i] = (byte)(255 - byArray2[i]);
                }
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " accessing CCITT filter " + exception);
        }
        return byArray2;
    }

    private final byte[] ascii85DecodeOLD(byte[] byArray) {
        int n;
        int n2 = 0;
        String string = "";
        CharArrayWriter charArrayWriter = new CharArrayWriter(byArray.length);
        BufferedReader bufferedReader = null;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
            if (bufferedReader != null) {
                while ((string = bufferedReader.readLine()) != null) {
                    charArrayWriter.write(string);
                }
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading ASCII stream ");
        }
        char[] cArray = charArrayWriter.toCharArray();
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        int n3 = cArray.length;
        for (n = 0; n < n3; ++n) {
            if (cArray[n] != 'z') continue;
            ++n2;
        }
        n = 0;
        long l = 0L;
        byte[] byArray2 = new byte[n3 + 1 + n2 * 3];
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            int n5;
            l = 0L;
            char c = cArray[i];
            while (c == '\n' || c == '\r') {
                c = cArray[++i];
            }
            if (c == 'z') {
                for (n5 = 0; n5 < 4; ++n5) {
                    byArray2[n] = 0;
                    ++n;
                }
                continue;
            }
            if (n3 - i <= 4 || c <= ' ' || c >= 'v') continue;
            for (n4 = 0; n4 < 5; ++n4) {
                c = cArray[i];
                while (c == '\n' || c == '\r') {
                    c = cArray[++i];
                }
                ++i;
                l += (long)(c - 33) * base_85_indices[n4];
            }
            for (n5 = 0; n5 < 4; ++n5) {
                byArray2[n] = (byte)(l / hex_indices[n5] & 0xFFL);
                ++n;
            }
            --i;
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 0, byArray3, 0, n);
        return byArray3;
    }

    private final byte[] ascii85DecodeNEW(byte[] byArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        String string = "";
        int n4 = byArray.length;
        for (n = 0; n < n4; ++n) {
            if (byArray[n] == 122) {
                ++n2;
            }
            if (byArray[n] != 10 && byArray[n] != 10) continue;
            ++n3;
        }
        n = 0;
        long l = 0L;
        byte[] byArray2 = new byte[n4 - n3 + 1 + n2 * 3];
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            l = 0L;
            byte by = byArray[i];
            while (by == 10 || by == 13) {
                if (++i == n4) {
                    by = 0;
                    continue;
                }
                by = byArray[i];
            }
            if (by == 122) {
                for (int j = 0; j < 4; ++j) {
                    byArray2[n] = 0;
                    ++n;
                }
                continue;
            }
            if (n4 - i <= 4 || by <= 32 || by >= 118) continue;
            String string2 = "";
            for (n5 = 0; n5 < 5; ++n5) {
                by = byArray[i];
                string2 = string2 + by + " ";
                while (by == 10 || by == 13) {
                    if (++i == n4) {
                        by = 0;
                        continue;
                    }
                    by = byArray[i];
                }
                ++i;
                if ((by <= 32 || by >= 118) && by != 126) continue;
                l += (long)(by - 33) * base_85_indices[n5];
            }
            for (int j = 0; j < 4; ++j) {
                byArray2[n] = (byte)(l / hex_indices[j] & 0xFFL);
                ++n;
            }
            --i;
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 0, byArray3, 0, n);
        return byArray3;
    }

    private final void ascii85Decode(BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream) {
        long l = 0L;
        int n = 0;
        try {
            int n2 = bufferedInputStream.available();
            int n3 = 0;
            boolean bl = false;
            while (bufferedInputStream.available() > 0) {
                int n4;
                l = 0L;
                n = this.read(bufferedInputStream);
                if (n == 122) {
                    for (int i = 0; i < 4; ++i) {
                        bufferedOutputStream.write(0);
                    }
                    continue;
                }
                if (bufferedInputStream.available() < 4 || n <= 32 || n >= 118) continue;
                n3 = n;
                l += (long)(n - 33) * base_85_indices[0];
                String string = "";
                for (n4 = 1; n4 < 5; ++n4) {
                    n = this.read(bufferedInputStream);
                    string = string + n + " ";
                    if (n == -1) {
                        n = 0;
                    }
                    if (n == -1) {
                        bl = true;
                    }
                    n3 = n;
                    if ((n <= 32 || n >= 118) && n != 126) continue;
                    l += (long)(n - 33) * base_85_indices[n4];
                }
                if (bl) continue;
                for (n4 = 0; n4 < 4; ++n4) {
                    byte by = (byte)(l / hex_indices[n4] & 0xFFL);
                    bufferedOutputStream.write(by);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private int read(BufferedInputStream bufferedInputStream) throws IOException {
        int n = bufferedInputStream.read();
        while (n == 13 || n == 10) {
            n = bufferedInputStream.read();
        }
        return n;
    }

    private final byte[] asciiHexDecode(byte[] byArray) throws IOException {
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        BufferedReader bufferedReader = null;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
            if (bufferedReader != null) {
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuffer2.append(string);
                }
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading ASCII stream ");
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        int n = stringBuffer2.length();
        int n2 = 0;
        int n3 = 0;
        char c = ' ';
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        do {
            if (!((c = (char)stringBuffer2.charAt(n2)) >= '0' & c <= '9' | c >= 'a' & c <= 'f' | c >= 'A' & c <= 'F')) continue;
            stringBuffer.append(c);
            if (n3 == 1) {
                byteArrayOutputStream.write(Integer.valueOf(stringBuffer.toString(), 16));
                n3 = 0;
                stringBuffer = new StringBuffer();
                continue;
            }
            ++n3;
        } while (c != '>' && ++n2 != n);
        if (n3 == 1) {
            stringBuffer.append('0');
            byteArrayOutputStream.write(Integer.valueOf(stringBuffer.toString(), 16));
        }
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private final void asciiHexDecode(BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        char c = ' ';
        int n = bufferedInputStream.available();
        for (int i = 0; i < n; ++i) {
            c = (char)bufferedInputStream.read();
            while (c == '\n') {
                c = (char)bufferedInputStream.read();
            }
            if (c >= '0' & c <= '9' | c >= 'a' & c <= 'f' | c >= 'A' & c <= 'F') {
                stringBuffer.append(c);
                if (n == 1) {
                    bufferedOutputStream.write(Integer.valueOf(stringBuffer.toString(), 16));
                    n = 0;
                    stringBuffer = new StringBuffer();
                } else {
                    ++n;
                }
            }
            if (c == '>') break;
        }
        if (n == 1) {
            stringBuffer.append('0');
            bufferedOutputStream.write(Integer.valueOf(stringBuffer.toString(), 16));
        }
    }

    private final byte[] flateDecode(byte[] byArray, Map map, String string) throws Exception {
        int n;
        Object object;
        byte[] byArray2 = null;
        int n2 = 1;
        String string2 = (String)map.get("Predictor");
        if (string2 != null) {
            n2 = Integer.parseInt(string2);
        }
        if (byArray != null) {
            object = new Inflater();
            ((Inflater)object).setInput(byArray);
            n = byArray.length;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
            int n3 = 512000;
            if (n < n3) {
                n3 = n;
            }
            byte[] byArray3 = new byte[n3];
            int n4 = 20;
            while (!((Inflater)object).finished()) {
                int n5 = ((Inflater)object).inflate(byArray3);
                byteArrayOutputStream.write(byArray3, 0, n5);
                if (((Inflater)object).getRemaining() != 0) continue;
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        if (this.bis != null) {
            try {
                object = new InflaterInputStream(this.bis);
                n = 0;
                while (true) {
                    int n6 = ((InputStream)object).read();
                    if (byArray2 != null && n6 != (byArray2[n] & 0xFF)) {
                        System.out.println("Different in flate at " + n);
                        System.exit(1);
                    }
                    if (((InputStream)object).available() == 0 || n6 == -1) break;
                    this.streamCache.write(n6);
                    ++n;
                }
                if (n2 != 1 && n2 != 10) {
                    this.streamCache.flush();
                    this.streamCache.close();
                    if (string != null) {
                        this.setupCachedObjectForDecoding(byArray, string, false, this.filter_type);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        byArray2 = this.applyPredictor(n2, map, byArray);
        return byArray2;
    }

    private void applyPredictorFunction(int n, Map map, BufferedInputStream bufferedInputStream, OutputStream outputStream) throws Exception {
        int n2 = n;
        int n3 = bufferedInputStream.available();
        int n4 = 1;
        int n5 = 8;
        int n6 = 1;
        boolean bl = true;
        String string = (String)map.get("Colors");
        if (string != null) {
            n4 = Integer.parseInt(string);
        }
        if ((string = (String)map.get("BitsPerComponent")) != null) {
            n5 = Integer.parseInt(string);
        }
        if ((string = (String)map.get("Columns")) != null) {
            n6 = Integer.parseInt(string);
        }
        int n7 = (n4 * n5 + 7) / 8;
        int n8 = (n6 * n4 * n5 + 7) / 8 + n7;
        byte[] byArray = new byte[n8];
        byte[] byArray2 = new byte[n8];
        try {
            int n9 = 0;
            while (n3 > n9) {
                int n10;
                n2 = n;
                if (n2 == 15) {
                    n2 = bufferedInputStream.read();
                    if (n2 == -1) break;
                    n2 += 10;
                } else if (n2 >= 10) {
                    bufferedInputStream.read();
                }
                int n11 = 0;
                int n12 = n7;
                int n13 = n8;
                while (n12 < n13 && (n11 = bufferedInputStream.read(byArray, n12, n13 - n12)) != -1) {
                    n12 += n11;
                    n9 += n11;
                }
                if (n11 == -1) break;
                switch (n2) {
                    case 2: {
                        int n14;
                        int n15;
                        for (n10 = n7; n10 < n8; ++n10) {
                            n15 = byArray[n10] & 0xFF;
                            n14 = byArray2[n10 - n7] & 0xFF;
                            byArray[n10] = (byte)(n15 + n14 & 0xFF);
                            outputStream.write(byArray[n10]);
                        }
                        break;
                    }
                    case 10: {
                        for (n10 = n7; n10 < n8; ++n10) {
                            outputStream.write(byArray[n10]);
                        }
                        break;
                    }
                    case 11: {
                        int n14;
                        int n15;
                        for (n10 = n7; n10 < n8; ++n10) {
                            n15 = byArray[n10] & 0xFF;
                            n14 = byArray[n10 - n7] & 0xFF;
                            byArray[n10] = (byte)(n15 + n14);
                            outputStream.write(byArray[n10]);
                        }
                        break;
                    }
                    case 12: {
                        int n14;
                        int n15;
                        for (n10 = n7; n10 < n8; ++n10) {
                            n15 = byArray[n10] & 0xFF;
                            n14 = byArray2[n10] & 0xFF;
                            byArray[n10] = (byte)(n15 + n14 & 0xFF);
                            outputStream.write(byArray[n10]);
                        }
                        break;
                    }
                    case 13: {
                        int n14;
                        int n15;
                        for (n10 = n7; n10 < n8; ++n10) {
                            n15 = byArray[n10] & 0xFF;
                            n14 = (byArray[n10 - n7] & 0xFF) + (byArray2[n10] & 0xFF) >> 1;
                            byArray[n10] = (byte)(n15 + n14);
                            outputStream.write(byArray[n10]);
                        }
                        break;
                    }
                    case 14: {
                        int n14;
                        int n15;
                        for (n10 = n7; n10 < n8; ++n10) {
                            n15 = byArray[n10 - n7] & 0xFF;
                            n14 = byArray2[n10] & 0xFF;
                            int n16 = byArray2[n10 - n7] & 0xFF;
                            int n17 = n15 + n14 - n16;
                            int n18 = n17 - n15;
                            int n19 = n17 - n14;
                            int n20 = n17 - n16;
                            if (n18 < 0) {
                                n18 = -n18;
                            }
                            if (n19 < 0) {
                                n19 = -n19;
                            }
                            if (n20 < 0) {
                                n20 = -n20;
                            }
                            byArray[n10] = n18 <= n19 && n18 <= n20 ? (byte)(byArray[n10] + n15) : (n19 <= n20 ? (byte)(byArray[n10] + n14) : (byte)(byArray[n10] + n16));
                            outputStream.write(byArray[n10]);
                        }
                        break;
                    }
                    case 15: {
                        break;
                    }
                }
                for (n10 = 0; n10 < byArray2.length; ++n10) {
                    byArray2[n10] = byArray[n10];
                }
            }
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private byte[] applyPredictor(int n, Map map, byte[] byArray) throws Exception {
        boolean bl;
        if (n == 1 || n == 10) {
            return byArray;
        }
        boolean bl2 = bl = byArray == null;
        if (bl) {
            this.applyPredictorFunction(n, map, this.bis, this.streamCache);
            return null;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.applyPredictorFunction(n, map, bufferedInputStream, byteArrayOutputStream);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return byArray2;
    }

    private boolean isCCITTEncoded(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("/CCITT") | string.startsWith("/CCF");
    }
}

