/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.impl;

import java.io.IOException;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import org.zkoss.json.JSONValue;
import org.zkoss.lang.JVMs;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.math.RoundingModes;
import org.zkoss.util.Locales;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.impl.Utils;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.ObjectPropertyAccess;
import org.zkoss.zk.ui.sys.PropertyAccess;
import org.zkoss.zul.impl.FormatInputElement;

public abstract class NumberInputElement
extends FormatInputElement {
    private int _rounding = 6;
    private Locale _locale;
    private static HashMap<String, PropertyAccess> _properties = new HashMap(2);

    public void setRoundingMode(int n) {
        if (this._rounding != n) {
            if (!JVMs.isJava6()) {
                throw new UnsupportedOperationException("Java 6 or above is required");
            }
            this._rounding = n;
            this.smartUpdate("rounding", n);
        }
    }

    public void setRoundingMode(String string) {
        this.setRoundingMode(RoundingModes.valueOf((String)string));
    }

    public int getRoundingMode() {
        return this._rounding;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public void setLocale(Locale locale) {
        if (!Objects.equals((Object)this._locale, (Object)locale)) {
            this._locale = locale;
            if (this.getFormat() == null) {
                this.setFormat(this.getDefaultFormat());
            }
            this.invalidate();
        }
    }

    public void setLocale(String string) {
        this.setLocale(string != null && string.length() > 0 ? Locales.getLocale((String)string) : null);
    }

    private String getRealSymbols() {
        boolean bl;
        String string = this.getFormat();
        boolean bl2 = bl = string != null && string.startsWith("locale:");
        if (this._locale != null || bl) {
            Locale locale = bl ? Locales.getLocale((String)string.substring(string.indexOf(":") + 1), (char)'-') : this._locale;
            String string2 = locale.toString();
            if (Utils.markClientInfoPerDesktop((Desktop)this.getDesktop(), (String)("org.zkoss.zul.impl.NumberInputElement" + string2))) {
                DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("GROUPING", String.valueOf(decimalFormatSymbols.getGroupingSeparator()));
                hashMap.put("DECIMAL", String.valueOf(decimalFormatSymbols.getDecimalSeparator()));
                hashMap.put("PERCENT", String.valueOf(decimalFormatSymbols.getPercent()));
                hashMap.put("PER_MILL", String.valueOf(decimalFormatSymbols.getPerMill()));
                hashMap.put("MINUS", String.valueOf(decimalFormatSymbols.getMinusSign()));
                return JSONValue.toJSONString((Object)new Object[]{string2, hashMap});
            }
            return JSONValue.toJSONString((Object)new Object[]{string2, null});
        }
        return null;
    }

    protected Locale getDefaultLocale() {
        return this._locale != null ? this._locale : Locales.getCurrent();
    }

    @Override
    protected void renderProperties(ContentRenderer contentRenderer) throws IOException {
        super.renderProperties(contentRenderer);
        if (this._rounding != 6) {
            contentRenderer.render("_rounding", this._rounding);
        }
        if (this._locale != null) {
            contentRenderer.render("localizedSymbols", this.getRealSymbols());
        }
    }

    protected String getDefaultFormat() {
        return Library.getProperty((String)"org.zkoss.zul.numberFormat", (String)"##,##0.##");
    }

    protected String formatNumber(Object object, String string) {
        DecimalFormat decimalFormat;
        block6: {
            String string2;
            if (object == null) {
                return "";
            }
            decimalFormat = (DecimalFormat)NumberFormat.getInstance(this.getDefaultLocale());
            if (this._rounding != 6) {
                decimalFormat.setRoundingMode(RoundingMode.valueOf(this._rounding));
            }
            if ((string2 = this.getFormat()) == null) {
                string2 = string;
            }
            if (string2 != null) {
                try {
                    decimalFormat.applyPattern(string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (this._locale == null) break block6;
                    decimalFormat.applyLocalizedPattern(string2);
                }
            }
        }
        return decimalFormat.format(object);
    }

    protected Object[] toNumberOnly(String string) {
        char c;
        char c2;
        int n;
        if (string == null) {
            return new Object[]{null, null};
        }
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(this.getDefaultLocale());
        char c3 = decimalFormatSymbols.getGroupingSeparator();
        char c4 = decimalFormatSymbols.getDecimalSeparator();
        char c5 = decimalFormatSymbols.getPercent();
        char c6 = decimalFormatSymbols.getPerMill();
        char c7 = decimalFormatSymbols.getMinusSign();
        String string2 = this.getFormat();
        StringBuffer stringBuffer = null;
        int n2 = 0;
        boolean bl = false;
        int n3 = string.length();
        for (n = 0; n < n3; ++n) {
            char c8;
            c2 = string.charAt(n);
            c = '\u0000';
            if (c2 == c5) {
                n2 += 2;
                c = '\u0001';
            } else if (c2 == c6) {
                n2 += 3;
                c = '\u0001';
            } else if (c2 == '(') {
                bl = true;
                c = '\u0001';
            } else if (c2 == '+') {
                c = '\u0001';
            }
            if (c == '\u0000') {
                char c9 = c = (c2 < '0' || c2 > '9') && c2 != c4 && c2 != c7 && c2 != '+' && (Character.isWhitespace(c2) || c2 == c3 || c2 == ')' || string2 != null && string2.indexOf(c2) >= 0) ? (char)'\u0001' : '\u0000';
            }
            if (c != '\u0000') {
                if (stringBuffer != null) continue;
                stringBuffer = new StringBuffer(n3).append(string.substring(0, n));
                continue;
            }
            char c10 = c2 == c7 ? (char)'-' : (c8 = c2 == c4 ? (char)'.' : c2);
            if (c2 != c8) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(n3).append(string.substring(0, n));
                }
                stringBuffer.append(c8);
                continue;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append(c8);
        }
        if (bl) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(string.length() + 1).append(string);
            }
            if (stringBuffer.length() > 0) {
                if (stringBuffer.charAt(0) == '-') {
                    stringBuffer.deleteCharAt(0);
                } else {
                    stringBuffer.insert(0, '-');
                }
            }
        }
        if (string2 != null && n2 > 0) {
            n = 0;
            c2 = string2.length();
            block1: while ((n3 = string2.indexOf(39, n)) >= 0) {
                while (++n3 < c2) {
                    c = string2.charAt(n3);
                    if (c == '%') {
                        n2 -= 2;
                    } else if (c == '\u2030') {
                        n2 -= 3;
                    } else if (c == '\'') break;
                    if (n2 > 0) continue;
                    n2 = 0;
                    break block1;
                }
                n = ++n3;
            }
        }
        return new Object[]{stringBuffer != null ? stringBuffer.toString() : string, new Integer(n2)};
    }

    @Override
    public PropertyAccess getPropertyAccess(String string) {
        PropertyAccess propertyAccess = _properties.get(string);
        if (propertyAccess != null) {
            return propertyAccess;
        }
        return super.getPropertyAccess(string);
    }

    static {
        _properties.put("locale", (PropertyAccess)new ObjectPropertyAccess(){

            public void setValue(Component component, Object object) {
                if (object instanceof String) {
                    ((NumberInputElement)component).setLocale((String)object);
                } else if (object instanceof Locale) {
                    ((NumberInputElement)component).setLocale((Locale)object);
                }
            }

            public String getValue(Component component) {
                return ((NumberInputElement)component).getLocale().toString();
            }
        });
    }
}

