/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.calendar.event;

import java.io.Serializable;
import java.util.Date;
import java.util.TimeZone;
import org.zkoss.calendar.api.CalendarEvent;
import org.zkoss.calendar.api.CalendarModel;

public class CalendarDataEvent
implements Serializable {
    private static final long serialVersionUID = 20090317164042L;
    public static final int CONTENTS_CHANGED = 0;
    public static final int INTERVAL_ADDED = 1;
    public static final int INTERVAL_REMOVED = 2;
    private final CalendarModel _model;
    private final int _type;
    private final Date _begin;
    private final Date _end;
    private final TimeZone _timezone;
    private final CalendarEvent _e;

    public CalendarDataEvent(CalendarModel model, int type, Date begin, Date end, TimeZone timezone) {
        if (model == null) {
            throw new IllegalArgumentException();
        }
        this._model = model;
        this._type = type;
        this._begin = begin;
        this._end = end;
        this._timezone = timezone;
        this._e = null;
    }

    public CalendarDataEvent(CalendarModel model, int type, CalendarEvent e, TimeZone timezone) {
        if (model == null) {
            throw new IllegalArgumentException();
        }
        this._model = model;
        this._type = type;
        this._begin = e != null ? e.getBeginDate() : null;
        this._end = e != null ? e.getEndDate() : null;
        this._e = e;
        this._timezone = timezone;
    }

    public CalendarModel getModel() {
        return this._model;
    }

    public int getType() {
        return this._type;
    }

    public Date getBeginDate() {
        return this._begin;
    }

    public Date getEndDate() {
        return this._end;
    }

    public TimeZone getTimeZone() {
        return this._timezone;
    }

    public CalendarEvent getCalendarEvent() {
        return this._e;
    }

    public String toString() {
        return "[CalendarDataEvent type=" + this._type + ", begin=" + this._begin + ", end=" + this._end + ']';
    }
}

