/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.log;

import fitlibrary.exception.FitLibraryException;
import java.io.PrintStream;

public class Log {
    static PrintStream out;
    static PrintStream err;
    static boolean DEBUG_ON;

    static {
        DEBUG_ON = false;
        out = System.out;
        err = System.out;
    }

    public static void setDebugging(boolean debugging) {
        DEBUG_ON = debugging;
    }

    public static void redirectErrorLoggingTo(PrintStream stream) {
        err = stream;
    }

    public static void info(String message) {
        out.println(message);
    }

    public static void info(Object object, String message) {
        Log.info(String.valueOf(Log.identify(object)) + message);
    }

    public static void error(String message) {
        err.println(message);
    }

    public static void error(Object object, String message) {
        Log.error(String.valueOf(Log.identify(object)) + message);
    }

    public static void error(String message, Throwable t) {
        Log.error(message);
        Log.error(t);
    }

    public static void error(Throwable t) {
        Log.error(t.getMessage());
        t.printStackTrace(err);
    }

    public static void logAndThrow(String message, Throwable ex) throws FitLibraryException {
        Log.error(message, ex);
        Log.rethrow(ex);
    }

    public static void logAndThrow(Exception ex) throws FitLibraryException {
        Log.error(ex);
        Log.rethrow(ex);
    }

    public static void debug(String message) {
        if (DEBUG_ON) {
            out.println(message);
        }
    }

    public static void debug(Object object, String message) {
        Log.debug(String.valueOf(Log.identify(object)) + message);
    }

    private static void rethrow(Throwable ex) {
        if (ex instanceof FitLibraryException) {
            throw (FitLibraryException)ex;
        }
        throw new FitLibraryException((Exception)ex);
    }

    private static String identify(Object object) {
        String name = object.getClass().getName();
        int lastDot = name.lastIndexOf(".");
        if (lastDot >= 0) {
            name = name.substring(lastDot + 1);
        }
        return String.valueOf(name) + ": ";
    }
}

