/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.mockWebServices.transactionFixture;

import fitlibrary.DoFixture;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.mockWebServices.MockingWebServices;
import fitlibrary.mockWebServices.requestMatcher.AcceptAnyRequestMatcher;
import fitlibrary.mockWebServices.requestMatcher.RequestMatcher;
import fitlibrary.mockWebServices.requestMatcher.UriRequestMatcher;
import fitlibrary.mockWebServices.responder.FileResponder;
import fitlibrary.mockWebServices.responder.LiteralResponder;
import fitlibrary.mockWebServices.responder.Responder;
import fitlibrary.mockWebServices.term.LeafTerm;
import fitlibrary.mockWebServices.term.RepeatingTerm;
import fitlibrary.mockWebServices.term.SequentialTerm;
import fitlibrary.mockWebServices.term.Term;
import fitlibrary.ws.message.ContentType;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class AbstractTransactionFixture
extends DoFixture {
    protected int port;
    protected MockingWebServices mockingWebServices;
    protected RequestMatcher requestMatcher = new AcceptAnyRequestMatcher();
    protected List<Responder> responders = new ArrayList<Responder>();
    protected SequentialTerm sequentialTerm = new SequentialTerm(new Term[0]);
    private boolean insertAtEnd = true;
    private ContentType responseContentType;

    public AbstractTransactionFixture(ContentType responseContentType, int port, MockingWebServices mockingWebServices) {
        this.responseContentType = responseContentType;
        this.port = port;
        this.mockingWebServices = mockingWebServices;
    }

    public void matchesURL(String url) {
        this.requestMatcher = this.requestMatcher.and(new UriRequestMatcher(url));
    }

    public void response(String responseString) {
        LiteralResponder responder = new LiteralResponder(this.wrapContents(responseString), this.responseContentType);
        this.responders.add(responder);
    }

    protected String wrapContents(String responseString) {
        return responseString;
    }

    public void then() {
        this.addToSequence();
    }

    public void insert() {
        this.insertAtEnd = false;
    }

    public void repeat() {
        if (this.responders.size() != 1) {
            throw new FitLibraryException("It only makes sense to repeat a single response.");
        }
        this.sequentialTerm.add(new RepeatingTerm(new LeafTerm(this.requestMatcher, this.responders.get(0))));
        this.reset();
    }

    public void responseFromFile(String fileName) {
        FileResponder responder = new FileResponder(fileName, this.responseContentType);
        this.responders.add(responder);
    }

    public void responsesFromFolder(String folderName) {
        File folder = new File(folderName);
        if (!folder.exists()) {
            throw new FitLibraryException("Doesn't exist: " + folderName);
        }
        List<String> list = Arrays.asList(folder.list());
        Collections.sort(list);
        for (String fileName : list) {
            if (fileName.endsWith(".svn")) continue;
            this.responseFromFile(String.valueOf(folderName) + "/" + fileName);
        }
    }

    public void responseCodeWith(int resultCode, String contents) {
        LiteralResponder responder = new LiteralResponder(resultCode, contents, this.responseContentType);
        this.responders.add(responder);
    }

    public void tearDown() throws Exception {
        this.addToSequence();
        this.mockingWebServices.or(this.port, this.sequentialTerm, this.insertAtEnd);
    }

    private void addToSequence() {
        if (this.responders.isEmpty()) {
            if (this.sequentialTerm.isEmpty()) {
                throw new FitLibraryException("Response has not been defined");
            }
            return;
        }
        for (Responder responder : this.responders) {
            this.sequentialTerm.add(new LeafTerm(this.requestMatcher, responder));
        }
        this.reset();
    }

    private void reset() {
        this.requestMatcher = new AcceptAnyRequestMatcher();
        this.responders.clear();
    }
}

