/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spider;

import fitlibrary.dynamicVariable.VariableResolver;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.TableFactory;
import fitlibrary.traverse.Traverse;
import java.util.regex.Pattern;

public class MultiLineMatchFixture
extends Traverse {
    private Object[] lines;

    public MultiLineMatchFixture(Object[] lines) {
        this.lines = lines;
    }

    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        if (this.lines.length == 0 && table.size() == 1) {
            ((Cell)((Row)table.at(0)).at(0)).pass(testResults);
        }
        int rowNo = 1;
        while (rowNo < table.size()) {
            Row row = (Row)table.at(rowNo);
            Cell cell = (Cell)row.at(0);
            if (row.size() > 1) {
                cell.error(testResults, "extra cell(s)");
                return null;
            }
            if (this.lines.length >= rowNo) {
                String regExp = cell.text((VariableResolver)this);
                String actualText = "";
                if (this.lines[rowNo - 1] != null) {
                    actualText = this.lines[rowNo - 1].toString().trim();
                }
                if (Pattern.compile(regExp, 32).matcher(actualText.trim()).matches()) {
                    cell.pass(testResults);
                } else {
                    cell.failWithStringEquals(testResults, actualText, (VariableResolver)this);
                }
            } else {
                cell.actualElementMissing(testResults);
            }
            ++rowNo;
        }
        int i = table.size() - 1;
        while (i < this.lines.length) {
            Cell cell = TableFactory.cell((String)"");
            cell.unexpected(testResults, "\"" + this.lines[i].toString() + "\"");
            Row row = TableFactory.row();
            row.add((Object)cell);
            table.add((Object)row);
            ++i;
        }
        return null;
    }
}

